/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.example.errors;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.model.ExampleProjectError;
import org.uberfire.client.mvp.UberElemental;

public class ExampleProjectErrorPresenter {
    private final TranslationService ts;
    private final View view;

    @Inject
    public ExampleProjectErrorPresenter(View view, TranslationService translationService) {
        this.view = view;
        this.ts = translationService;
    }

    public void initialize(List<ExampleProjectError> errors) {
        this.view.init(this);
        this.view.setErrors(errors.stream().map(this::translateError).collect(Collectors.toList()));
    }

    protected String translateError(ExampleProjectError error) {
        String id = error.getId();
        String message = error.getDescription() == null || error.getDescription().isEmpty() ? this.ts.getTranslation(this.getId(id)) : this.ts.format(this.getId(id), new Object[]{error.getDescription()});
        return "- " + (message == null ? error.getId() : message);
    }

    protected String getId(String id) {
        return id.substring(id.lastIndexOf(".") + 1);
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElemental<ExampleProjectErrorPresenter>,
    IsElement {
        public void setErrors(List<String> var1);
    }
}

