/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.contributors.SpaceContributorsUpdatedEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectCountUpdate;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.screens.EmptyLibraryScreen;
import org.kie.workbench.common.screens.library.client.screens.OrgUnitsMetricsScreen;
import org.kie.workbench.common.screens.library.client.screens.PopulatedLibraryScreen;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListPresenter;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.SpaceContributorsListServiceImpl;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.delete.DeleteOrganizationalUnitPopUpPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.spaces.Space;

@WorkbenchScreen(identifier="LibraryScreen", owningPerspective=LibraryPerspective.class)
public class LibraryScreen {
    private View view;
    private ManagedInstance<DeleteOrganizationalUnitPopUpPresenter> deleteOrganizationalUnitPopUpPresenters;
    private ProjectController projectController;
    private OrganizationalUnitController organizationalUnitController;
    private WorkspaceProjectContext projectContext;
    private EmptyLibraryScreen emptyLibraryScreen;
    private PopulatedLibraryScreen populatedLibraryScreen;
    private OrgUnitsMetricsScreen orgUnitsMetricsScreen;
    private ContributorsListPresenter contributorsListPresenter;
    private Caller<LibraryService> libraryService;
    private LibraryPlaces libraryPlaces;
    private SpaceContributorsListServiceImpl spaceContributorsListService;

    @Inject
    public LibraryScreen(View view, ManagedInstance<DeleteOrganizationalUnitPopUpPresenter> deleteOrganizationalUnitPopUpPresenters, WorkspaceProjectContext projectContext, ProjectController projectController, OrganizationalUnitController organizationalUnitController, EmptyLibraryScreen emptyLibraryScreen, PopulatedLibraryScreen populatedLibraryScreen, OrgUnitsMetricsScreen orgUnitsMetricsScreen, ContributorsListPresenter contributorsListPresenter, Caller<LibraryService> libraryService, LibraryPlaces libraryPlaces, SpaceContributorsListServiceImpl spaceContributorsListService) {
        this.view = view;
        this.deleteOrganizationalUnitPopUpPresenters = deleteOrganizationalUnitPopUpPresenters;
        this.projectContext = projectContext;
        this.projectController = projectController;
        this.organizationalUnitController = organizationalUnitController;
        this.emptyLibraryScreen = emptyLibraryScreen;
        this.populatedLibraryScreen = populatedLibraryScreen;
        this.orgUnitsMetricsScreen = orgUnitsMetricsScreen;
        this.contributorsListPresenter = contributorsListPresenter;
        this.libraryService = libraryService;
        this.libraryPlaces = libraryPlaces;
        this.spaceContributorsListService = spaceContributorsListService;
    }

    @PostConstruct
    public void init() {
        OrganizationalUnit activeOU = (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot initialize library screen without an active organizational unit."));
        this.view.init(this);
        this.view.setTitle(activeOU.getName());
        this.showProjects();
        this.contributorsListPresenter.setup(this.spaceContributorsListService, contributorsCount -> this.view.setContributorsCount((int)contributorsCount));
    }

    public void trySamples() {
        if (this.userCanCreateProjects()) {
            this.libraryPlaces.closeAllPlacesOrNothing(() -> {
                this.libraryPlaces.goToLibrary();
                this.libraryPlaces.goToTrySamples();
            });
        }
    }

    public void importProject() {
        if (this.userCanCreateProjects()) {
            this.libraryPlaces.goToImportRepositoryPopUp();
        }
    }

    public void delete() {
        if (this.userCanDeleteOrganizationalUnit()) {
            DeleteOrganizationalUnitPopUpPresenter deleteOrganizationalUnitPopUpPresenter = (DeleteOrganizationalUnitPopUpPresenter)this.deleteOrganizationalUnitPopUpPresenters.get();
            deleteOrganizationalUnitPopUpPresenter.show((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot delete organizational unit if none is active.")));
        }
    }

    public void showProjects() {
        OrganizationalUnit activeOU = (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot try to query library projects without an active organizational unit."));
        ((LibraryService)this.libraryService.call(this::setLibraryProjectScreen)).hasProjects(activeOU);
    }

    private void setLibraryProjectScreen(boolean hasProjects) {
        if (hasProjects) {
            this.showPopulatedLibraryScreen();
        } else {
            this.showEmptyLibraryScreen();
        }
    }

    private void showEmptyLibraryScreen() {
        this.view.setProjectsCount(0);
        if (this.view.isProjectsTabActive()) {
            this.view.updateContent(this.emptyLibraryScreen.getView().getElement());
        }
    }

    private void showPopulatedLibraryScreen() {
        this.view.setProjectsCount(this.populatedLibraryScreen.getProjectsCount());
        if (this.view.isProjectsTabActive()) {
            this.view.updateContent(this.populatedLibraryScreen.getView().getElement());
        }
    }

    public void showContributors() {
        if (this.view.isContributorsTabActive()) {
            this.view.updateContent(this.contributorsListPresenter.getView().getElement());
        }
    }

    public void showMetrics() {
        this.orgUnitsMetricsScreen.refresh();
        if (this.view.isMetricsTabActive()) {
            this.view.updateContent(this.orgUnitsMetricsScreen.getView().getElement());
        }
    }

    public boolean userCanCreateProjects() {
        return this.projectController.canCreateProjects(this.libraryPlaces.getActiveSpace());
    }

    public boolean userCanUpdateOrganizationalUnit() {
        return this.organizationalUnitController.canUpdateOrgUnit((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot try to update an organizational unit when none is active.")));
    }

    public boolean userCanDeleteOrganizationalUnit() {
        return this.organizationalUnitController.canDeleteOrgUnit((OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot try to delete an organizational unit when none is active.")));
    }

    public void onNewProject(@Observes NewProjectEvent e) {
        this.projectContext.getActiveOrganizationalUnit().ifPresent(p -> {
            if (this.eventOnCurrentSpace((OrganizationalUnit)p, e.getWorkspaceProject().getSpace())) {
                this.showProjects();
            }
        });
    }

    public void onRepositoryRemovedEvent(@Observes RepositoryRemovedEvent e) {
        this.projectContext.getActiveOrganizationalUnit().ifPresent(p -> {
            if (this.eventOnCurrentSpace((OrganizationalUnit)p, e.getRepository().getSpace())) {
                this.showProjects();
            }
        });
    }

    boolean eventOnCurrentSpace(OrganizationalUnit p, Space space) {
        return p.getSpace().getName().equalsIgnoreCase(space.getName());
    }

    public void onProjectCountUpdate(@Observes ProjectCountUpdate projectCountUpdate) {
        this.projectContext.getActiveOrganizationalUnit().ifPresent(p -> {
            if (this.eventOnCurrentSpace((OrganizationalUnit)p, projectCountUpdate.getSpace())) {
                this.view.setProjectsCount(projectCountUpdate.getCount());
            }
        });
    }

    public void onSpaceContributorsUpdated(@Observes SpaceContributorsUpdatedEvent spaceContributorsUpdatedEvent) {
        this.projectContext.getActiveOrganizationalUnit().ifPresent(p -> {
            if (this.eventOnCurrentSpace((OrganizationalUnit)p, spaceContributorsUpdatedEvent.getOrganizationalUnit().getSpace())) {
                this.view.setContributorsCount(spaceContributorsUpdatedEvent.getOrganizationalUnit().getContributors().size());
            }
        });
    }

    @OnClose
    public void onClose() {
        this.orgUnitsMetricsScreen.onClose();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Library Screen";
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElement<LibraryScreen> {
        public void setTitle(String var1);

        public void setProjectsCount(int var1);

        public void setContributorsCount(int var1);

        public void updateContent(HTMLElement var1);

        public boolean isProjectsTabActive();

        public boolean isContributorsTabActive();

        public boolean isMetricsTabActive();
    }
}

