/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project;

import com.google.gwt.core.client.Callback;
import elemental2.dom.HTMLElement;
import elemental2.promise.Promise;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.events.RepositoryContributorsUpdatedEvent;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.defaulteditor.client.editor.NewFileUploader;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.screens.assets.AssetsScreen;
import org.kie.workbench.common.screens.library.client.screens.assets.events.UpdatedAssetsEvent;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListPresenter;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ProjectContributorsListServiceImpl;
import org.kie.workbench.common.screens.library.client.screens.project.ProjectMetricsScreen;
import org.kie.workbench.common.screens.library.client.screens.project.actions.ProjectMainActions;
import org.kie.workbench.common.screens.library.client.screens.project.branch.delete.DeleteBranchPopUpScreen;
import org.kie.workbench.common.screens.library.client.screens.project.delete.DeleteProjectPopUpScreen;
import org.kie.workbench.common.screens.library.client.screens.project.rename.RenameProjectPopUpScreen;
import org.kie.workbench.common.screens.library.client.settings.SettingsPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.screens.projecteditor.client.validation.ProjectNameValidator;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.popups.CopyPopUpPresenter;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.workbench.events.NotificationEvent;

@WorkbenchScreen(identifier="ProjectScreen", owningPerspective=LibraryPerspective.class)
public class ProjectScreen {
    private Elemental2DomUtil elemental2DomUtil;
    protected WorkspaceProject workspaceProject;
    private final LibraryPlaces libraryPlaces;
    private AssetsScreen assetsScreen;
    private ContributorsListPresenter contributorsListScreen;
    private ProjectMetricsScreen projectMetricsScreen;
    private ProjectController projectController;
    private SettingsPresenter settingsPresenter;
    private final NewFileUploader newFileUploader;
    private final NewResourcePresenter newResourcePresenter;
    private ManagedInstance<DeleteProjectPopUpScreen> deleteProjectPopUpScreen;
    private ManagedInstance<DeleteBranchPopUpScreen> deleteBranchPopUpScreen;
    private ManagedInstance<RenameProjectPopUpScreen> renameProjectPopUpScreen;
    private Caller<LibraryService> libraryService;
    private View view;
    private Caller<ProjectScreenService> projectScreenService;
    private CopyPopUpPresenter copyPopUpPresenter;
    private ProjectNameValidator projectNameValidator;
    private Promises promises;
    private Event<NotificationEvent> notificationEvent;
    private ProjectContributorsListServiceImpl projectContributorsListService;
    private ProjectMainActions projectMainActions;

    @Inject
    public ProjectScreen(View view, LibraryPlaces libraryPlaces, AssetsScreen assetsScreen, ContributorsListPresenter contributorsListScreen, ProjectMetricsScreen projectMetricsScreen, ProjectController projectController, SettingsPresenter settingsPresenter, NewFileUploader newFileUploader, NewResourcePresenter newResourcePresenter, ManagedInstance<DeleteProjectPopUpScreen> deleteProjectPopUpScreen, ManagedInstance<DeleteBranchPopUpScreen> deleteBranchPopUpScreen, ManagedInstance<RenameProjectPopUpScreen> renameProjectPopUpScreen, Caller<LibraryService> libraryService, Caller<ProjectScreenService> projectScreenService, CopyPopUpPresenter copyPopUpPresenter, ProjectNameValidator projectNameValidator, Promises promises, Event<NotificationEvent> notificationEvent, ProjectContributorsListServiceImpl projectContributorsListService, ProjectMainActions projectMainActions) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.assetsScreen = assetsScreen;
        this.contributorsListScreen = contributorsListScreen;
        this.projectMetricsScreen = projectMetricsScreen;
        this.projectController = projectController;
        this.settingsPresenter = settingsPresenter;
        this.newFileUploader = newFileUploader;
        this.newResourcePresenter = newResourcePresenter;
        this.deleteProjectPopUpScreen = deleteProjectPopUpScreen;
        this.deleteBranchPopUpScreen = deleteBranchPopUpScreen;
        this.renameProjectPopUpScreen = renameProjectPopUpScreen;
        this.libraryService = libraryService;
        this.projectScreenService = projectScreenService;
        this.copyPopUpPresenter = copyPopUpPresenter;
        this.projectNameValidator = projectNameValidator;
        this.promises = promises;
        this.notificationEvent = notificationEvent;
        this.projectContributorsListService = projectContributorsListService;
        this.elemental2DomUtil = new Elemental2DomUtil();
        this.projectMainActions = projectMainActions;
    }

    @PostConstruct
    public void initialize() {
        this.workspaceProject = this.libraryPlaces.getActiveWorkspace();
        this.view.init(this);
        this.view.setTitle(this.libraryPlaces.getActiveWorkspace().getName());
        this.view.addMainAction(this.projectMainActions.getElement());
        this.resolveAssetsCount();
        this.showAssets();
        this.projectController.canUpdateProject(this.workspaceProject).then(userCanUpdateProject -> {
            this.view.setAddAssetVisible((boolean)userCanUpdateProject);
            this.view.setImportAssetVisible((boolean)userCanUpdateProject);
            this.view.setReimportVisible((boolean)userCanUpdateProject);
            this.newFileUploader.acceptContext((Callback)new Callback<Boolean, Void>(){

                public void onFailure(Void reason) {
                    ProjectScreen.this.view.setImportAssetVisible(false);
                }

                public void onSuccess(Boolean result) {
                    ProjectScreen.this.view.setImportAssetVisible(result != false && userCanUpdateProject != false);
                }
            });
            return this.promises.resolve();
        });
        boolean userCanCreateProjects = this.userCanCreateProjects();
        this.view.setDuplicateVisible(userCanCreateProjects);
        boolean userCanDeleteProject = this.userCanDeleteProject();
        this.view.setDeleteProjectVisible(userCanDeleteProject);
        this.projectController.canDeleteBranch(this.workspaceProject).then(userCanDeleteBranch -> {
            this.view.setDeleteBranchVisible((boolean)userCanDeleteBranch);
            return this.promises.resolve();
        });
        this.setupMainActions();
        List<Promise> permissionPromises = Arrays.asList(this.projectController.canUpdateProject(this.workspaceProject), this.projectController.canDeleteBranch(this.workspaceProject), this.promises.resolve((Object)this.userCanDeleteProject()), this.promises.resolve((Object)this.userCanCreateProjects()));
        this.promises.reduce(this.promises.resolve((Object)false), permissionPromises, (p1, p2) -> p1.then(resultP1 -> p2.then(resultP2 -> this.promises.resolve((Object)(resultP1 != false || resultP2 != false ? 1 : 0))))).then(thereAreActionsToDisplay -> {
            this.view.setActionsVisible((boolean)thereAreActionsToDisplay);
            return this.promises.resolve();
        });
        this.contributorsListScreen.setup(this.projectContributorsListService, contributorCount -> this.view.setContributorsCount((int)contributorCount));
    }

    private void setupMainActions() {
        this.projectController.canBuildProject(this.workspaceProject).then(userCanBuildProject -> {
            this.projectMainActions.setBuildEnabled((boolean)userCanBuildProject);
            return this.promises.resolve();
        });
        this.projectController.canDeployProject(this.workspaceProject).then(userCanDeployProject -> {
            this.projectMainActions.setDeployEnabled((boolean)userCanDeployProject);
            return this.promises.resolve();
        });
        this.projectMainActions.setRedeployEnabled(this.workspaceProject.getMainModule().getPom().getGav().isSnapshot());
    }

    @OnMayClose
    public boolean onMayClose() {
        return this.settingsPresenter.mayClose();
    }

    public void setAssetsCount(Integer assetsCount) {
        this.view.setAssetsCount(assetsCount);
    }

    public void onAddAsset(@Observes NewResourceSuccessEvent event) {
        this.resolveAssetsCount();
    }

    public void onAssetsUpdated(@Observes UpdatedAssetsEvent event) {
        this.resolveAssetsCount();
    }

    public void onRepositoryContributorsUpdated(@Observes RepositoryContributorsUpdatedEvent repositoryUpdatedEvent) {
        if (repositoryUpdatedEvent.getRepository().getIdentifier().equals(this.libraryPlaces.getActiveWorkspace().getRepository().getIdentifier())) {
            this.view.setContributorsCount(repositoryUpdatedEvent.getRepository().getContributors().size());
        }
    }

    public void changeProjectAndTitleWhenContextChange(@Observes WorkspaceProjectContextChangeEvent current) {
        if (current.getWorkspaceProject() != null) {
            this.workspaceProject = current.getWorkspaceProject();
            this.view.setTitle(this.workspaceProject.getName());
            this.setupMainActions();
        }
    }

    private void resolveAssetsCount() {
        ((LibraryService)this.libraryService.call(numberOfAssets -> this.setAssetsCount((Integer)numberOfAssets))).getNumberOfAssets(this.workspaceProject);
    }

    public void showAssets() {
        this.view.setContent(this.assetsScreen.getView().getElement());
    }

    public void showMetrics() {
        this.projectMetricsScreen.onStartup(this.workspaceProject);
        this.view.setContent(this.elemental2DomUtil.asHTMLElement(this.projectMetricsScreen.getView().getElement()));
    }

    public void showContributors() {
        this.view.setContent(this.elemental2DomUtil.asHTMLElement(this.contributorsListScreen.getView().getElement()));
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.libraryPlaces.getActiveWorkspace().getName();
    }

    public void deleteProject() {
        if (this.userCanDeleteProject()) {
            DeleteProjectPopUpScreen popUp = (DeleteProjectPopUpScreen)this.deleteProjectPopUpScreen.get();
            popUp.show(this.workspaceProject);
        }
    }

    public void deleteBranch() {
        this.projectController.canDeleteBranch(this.workspaceProject).then(userCanDeleteBranch -> {
            if (userCanDeleteBranch.booleanValue()) {
                DeleteBranchPopUpScreen popUp = (DeleteBranchPopUpScreen)this.deleteBranchPopUpScreen.get();
                popUp.show(this.libraryPlaces.getActiveWorkspace().getBranch());
            }
            return this.promises.resolve();
        });
    }

    public void addAsset() {
        this.projectController.canUpdateProject(this.workspaceProject).then(userCanUpdateProject -> {
            if (userCanUpdateProject.booleanValue()) {
                this.libraryPlaces.goToAddAsset();
            }
            return this.promises.resolve();
        });
    }

    public void importAsset() {
        this.projectController.canUpdateProject(this.workspaceProject).then(userCanUpdateProject -> {
            if (userCanUpdateProject.booleanValue()) {
                this.newFileUploader.getCommand(this.newResourcePresenter).execute();
            }
            return this.promises.resolve();
        });
    }

    public void showSettings() {
        this.settingsPresenter.setupUsingCurrentSection().then(i -> {
            SettingsPresenter.View settingsView = this.settingsPresenter.getView();
            this.view.setContent(settingsView.getElement());
            return this.promises.resolve();
        });
    }

    public void rename() {
        this.projectController.canUpdateProject(this.workspaceProject).then(userCanUpdateProject -> {
            if (userCanUpdateProject.booleanValue()) {
                RenameProjectPopUpScreen popUp = (RenameProjectPopUpScreen)this.renameProjectPopUpScreen.get();
                popUp.show(this.workspaceProject);
            }
            return this.promises.resolve();
        });
    }

    public void duplicate() {
        if (this.userCanCreateProjects()) {
            this.copyPopUpPresenter.show(this.workspaceProject.getRootPath(), (Validator)this.projectNameValidator, this.getDuplicateCommand());
        }
    }

    CommandWithFileNameAndCommitMessage getDuplicateCommand() {
        return details -> {
            this.copyPopUpPresenter.getView().hide();
            this.view.showBusyIndicator(this.view.getLoadingMessage());
            this.promises.promisify(this.projectScreenService, s -> s.copy(this.workspaceProject, details.getNewFileName())).then(i -> {
                this.view.hideBusyIndicator();
                this.notificationEvent.fire((Object)new NotificationEvent(this.view.getItemSuccessfullyDuplicatedMessage(), NotificationEvent.NotificationType.SUCCESS));
                return this.promises.resolve();
            }).catch_(this::onError);
        };
    }

    public void reimport() {
        this.projectController.canUpdateProject(this.workspaceProject).then(userCanUpdateProject -> {
            if (userCanUpdateProject.booleanValue()) {
                Path pomXMLPath = this.workspaceProject.getMainModule().getPomXMLPath();
                this.view.showBusyIndicator(this.view.getLoadingMessage());
                this.promises.promisify(this.projectScreenService, s -> s.reImport(pomXMLPath)).then(i -> {
                    this.view.hideBusyIndicator();
                    this.notificationEvent.fire((Object)new NotificationEvent(this.view.getReimportSuccessfulMessage(), NotificationEvent.NotificationType.SUCCESS));
                    return this.promises.resolve();
                }).catch_(this::onError);
            }
            return this.promises.resolve();
        });
    }

    private Promise<Object> onError(Object o) {
        return this.promises.catchOrExecute(o, e -> {
            this.view.hideBusyIndicator();
            return this.promises.reject(e);
        }, x -> {
            this.view.hideBusyIndicator();
            return this.promises.reject(x);
        });
    }

    public boolean userCanDeleteProject() {
        return this.projectController.canDeleteProject(this.workspaceProject);
    }

    public boolean userCanCreateProjects() {
        return this.projectController.canCreateProjects(this.libraryPlaces.getActiveSpace());
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElemental<ProjectScreen> {
        public void setAssetsCount(int var1);

        public void setContributorsCount(int var1);

        public void setContent(HTMLElement var1);

        public void setTitle(String var1);

        public void setAddAssetVisible(boolean var1);

        public void setImportAssetVisible(boolean var1);

        public void setDuplicateVisible(boolean var1);

        public void setReimportVisible(boolean var1);

        public void setDeleteProjectVisible(boolean var1);

        public void setDeleteBranchVisible(boolean var1);

        public void setActionsVisible(boolean var1);

        public String getLoadingMessage();

        public String getItemSuccessfullyDuplicatedMessage();

        public String getReimportSuccessfulMessage();

        public void showBusyIndicator(String var1);

        public void hideBusyIndicator();

        public void addMainAction(HTMLElement var1);
    }
}

