/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.actions;

import elemental2.dom.HTMLElement;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.test.TestRunnerService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.client.screens.project.actions.ProjectMainActionsView;
import org.kie.workbench.common.screens.projecteditor.client.build.BuildExecutor;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class ProjectMainActions
implements ProjectMainActionsView.Presenter,
IsElement {
    private final BuildExecutor buildExecutor;
    private final ProjectMainActionsView view;
    private final Caller<TestRunnerService> testRunnerService;
    private final User user;
    private TranslationService ts;
    private PlaceManager placeManager;
    private WorkspaceProjectContext workspaceProjectContext;
    private boolean buildEnabled;
    private boolean deployEnabled;
    private boolean redeployEnabled;

    @Inject
    public ProjectMainActions(BuildExecutor buildExecutor, ProjectMainActionsView view, Caller<TestRunnerService> testRunnerService, WorkspaceProjectContext workspaceProjectContext, PlaceManager placeManager, TranslationService ts, User user) {
        this.buildExecutor = buildExecutor;
        this.view = view;
        this.testRunnerService = testRunnerService;
        this.workspaceProjectContext = workspaceProjectContext;
        this.placeManager = placeManager;
        this.ts = ts;
        this.user = user;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setBuildEnabled(boolean buildEnabled) {
        this.buildEnabled = buildEnabled;
        this.view.setBuildDropDownEnabled(buildEnabled);
    }

    public void setDeployEnabled(boolean deployEnabled) {
        this.deployEnabled = deployEnabled;
        this.view.setBuildAndDeployDropDownEnabled(deployEnabled);
    }

    public void setRedeployEnabled(boolean redeployEnabled) {
        this.redeployEnabled = redeployEnabled;
        this.view.setRedeployEnabled(redeployEnabled);
    }

    @Override
    public void triggerBuild() {
        if (this.buildEnabled) {
            this.buildExecutor.triggerBuild();
        }
    }

    @Override
    public void triggerBuildAndInstall() {
        if (this.buildEnabled) {
            this.buildExecutor.triggerBuildAndInstall();
        }
    }

    @Override
    public void triggerBuildAndDeploy() {
        if (this.deployEnabled) {
            this.buildExecutor.triggerBuildAndDeploy();
        }
    }

    @Override
    public void triggerRedeploy() {
        if (this.deployEnabled && this.redeployEnabled) {
            this.buildExecutor.triggerRedeploy();
        }
    }

    @Override
    public void onRunTest() {
        Optional activeModule = this.workspaceProjectContext.getActiveModule();
        if (activeModule.isPresent()) {
            this.view.showBusyIndicator(this.ts.getTranslation("Testing"));
            this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("org.kie.guvnor.TestResults"));
            ((TestRunnerService)this.testRunnerService.call(response -> this.view.hideBusyIndicator())).runAllTests(this.user.getIdentifier(), ((Module)activeModule.get()).getRootPath());
        }
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }
}

