/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.actions;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.Node;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.messageconsole.client.console.widget.button.ViewHideAlertsButtonPresenter;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.project.actions.ProjectMainActionsView;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Templated
public class ProjectMainActionsViewImpl
implements ProjectMainActionsView,
IsElement {
    private static final String DISABLED_CLASS = "disabled";
    @Inject
    @DataField
    private HTMLDivElement alerts;
    @Inject
    @DataField
    private HTMLButtonElement build;
    @Inject
    @DataField
    private HTMLButtonElement buildCaret;
    @Inject
    @DataField
    private HTMLAnchorElement install;
    @Inject
    @DataField
    private HTMLButtonElement deploy;
    @Inject
    @DataField
    private HTMLButtonElement deployCaret;
    @Inject
    @DataField
    private HTMLLIElement redeployLI;
    @Inject
    @DataField
    private HTMLAnchorElement redeploy;
    @Inject
    @DataField
    private HTMLButtonElement runTests;
    @Inject
    private ViewHideAlertsButtonPresenter viewHideAlertsButtonPresenter;
    private ProjectMainActionsView.Presenter presenter;
    private boolean redeployEnabled = true;

    @PostConstruct
    public void init() {
        this.alerts.appendChild((Node)this.viewHideAlertsButtonPresenter.getView().getElement());
    }

    public void init(ProjectMainActionsView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setBuildDropDownEnabled(boolean enabled) {
        this.build.disabled = !enabled;
        boolean bl = this.buildCaret.disabled = !enabled;
        if (enabled) {
            this.install.classList.remove(new String[]{DISABLED_CLASS});
        } else {
            this.install.classList.add(new String[]{DISABLED_CLASS});
        }
    }

    @Override
    public void setBuildAndDeployDropDownEnabled(boolean enabled) {
        this.deploy.disabled = !enabled;
        this.deployCaret.disabled = !enabled;
    }

    @Override
    public void setRedeployEnabled(boolean enabled) {
        if (enabled) {
            this.redeployLI.classList.remove(new String[]{DISABLED_CLASS});
        } else {
            this.redeployLI.classList.add(new String[]{DISABLED_CLASS});
        }
        this.redeployEnabled = enabled;
    }

    @Override
    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    @Override
    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @EventHandler(value={"build"})
    public void onBuild(ClickEvent clickEvent) {
        this.presenter.triggerBuild();
    }

    @EventHandler(value={"install"})
    public void onInstall(ClickEvent clickEvent) {
        this.presenter.triggerBuildAndInstall();
    }

    @EventHandler(value={"deploy"})
    public void onDeploy(ClickEvent clickEvent) {
        this.presenter.triggerBuildAndDeploy();
    }

    @EventHandler(value={"runTests"})
    public void onRunTests(ClickEvent clickEvent) {
        this.presenter.onRunTest();
    }

    @EventHandler(value={"redeploy"})
    public void onRedeploy(ClickEvent clickEvent) {
        if (this.redeployEnabled) {
            this.presenter.triggerRedeploy();
        } else {
            clickEvent.stopPropagation();
        }
    }
}

