/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.sections.knowledgebases.item;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.settings.sections.knowledgebases.item.KnowledgeBaseItemPresenter;

@Templated(value="#root")
public class KnowledgeBaseItemView
implements KnowledgeBaseItemPresenter.View {
    @Inject
    @DataField(value="is-default")
    private HTMLInputElement isDefault;
    @Inject
    @DataField(value="name")
    private HTMLInputElement name;
    @Inject
    @DataField(value="remove-button")
    private HTMLAnchorElement removeButton;
    @Inject
    @DataField(value="add-included-knowledge-base-button")
    private HTMLAnchorElement addIncludedKnowledgeBaseButton;
    @Inject
    @DataField(value="add-package-button")
    private HTMLAnchorElement addPackageButton;
    @Inject
    @DataField(value="included-knowledge-bases-list")
    private HTMLDivElement includedKnowledgeBasesList;
    @Inject
    @DataField(value="equals-behavior-select-container")
    private HTMLDivElement equalsBehaviorSelectContainer;
    @Inject
    @DataField(value="event-processing-model-select-container")
    private HTMLDivElement eventProcessingModelSelectContainer;
    @Inject
    @DataField(value="packages-list")
    private HTMLDivElement packagesList;
    @Inject
    @DataField(value="knowledge-sessions-link")
    private HTMLAnchorElement knowledgeSessionsLink;
    @Inject
    @Named(value="span")
    @DataField(value="knowledge-sessions-count")
    private HTMLElement knowledgeSessionsCount;
    private KnowledgeBaseItemPresenter presenter;

    @EventHandler(value={"remove-button"})
    private void onRemoveButtonClicked(ClickEvent ignore) {
        this.presenter.remove();
    }

    @EventHandler(value={"add-included-knowledge-base-button"})
    private void onAddIncludedKnowledgeBaseButtonClicked(ClickEvent ignore) {
        this.presenter.addNewIncludedKnowledgeBase();
    }

    @EventHandler(value={"add-package-button"})
    private void onAddPackageButtonClicked(ClickEvent ignore) {
        this.presenter.addPackage();
    }

    @EventHandler(value={"knowledge-sessions-link"})
    private void onKnowledgeSessionsLinkClicked(ClickEvent ignore) {
        this.presenter.showKnowledgeSessionsModal();
    }

    @EventHandler(value={"is-default"})
    private void onIsDefaultChanged(ChangeEvent ignore) {
        this.presenter.setDefault(this.isDefault.checked);
    }

    public void init(KnowledgeBaseItemPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setName(String name) {
        this.name.value = name;
    }

    @Override
    public Element getPackagesListElement() {
        return this.packagesList;
    }

    @Override
    public Element getIncludedKnowledgeBasesListElement() {
        return this.includedKnowledgeBasesList;
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.isDefault.checked = isDefault;
    }

    @Override
    public Element getEqualsBehaviorSelectContainer() {
        return this.equalsBehaviorSelectContainer;
    }

    @Override
    public Element getEventProcessingModelSelectContainer() {
        return this.eventProcessingModelSelectContainer;
    }

    @Override
    public void setKnowledgeSessionsCount(int size) {
        this.knowledgeSessionsCount.textContent = Integer.toString(size);
    }

    @EventHandler(value={"name"})
    public void onNameChange(@ForEvent(value={"change"}) Event event) {
        this.presenter.onNameChange(this.name.value);
    }
}

