/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;

@ApplicationScoped
public class DateUtils {
    public static final int ONE_DAY_IN_MS = 86400000;
    private static final int SEVEN_DAYS = 7;
    private TranslationService translationService;

    @Inject
    public DateUtils(TranslationService translationService) {
        this.translationService = translationService;
    }

    public String format(Date date) {
        int diffInDays = this.diffInDaysFromNow(date);
        if (diffInDays < 7) {
            return this.formatInDays(diffInDays);
        }
        return this.formatInWeeks(diffInDays);
    }

    private int diffInDaysFromNow(Date date) {
        int diffInDays = (int)((new Date().getTime() - date.getTime()) / 86400000L);
        return Math.abs(diffInDays);
    }

    private String formatInDays(int diffInDays) {
        if (diffInDays == 0) {
            return this.translationService.getTranslation("Today");
        }
        if (diffInDays == 1) {
            return this.translationService.getTranslation("OneDayAgo");
        }
        return this.translationService.format("DaysAgo", new Object[]{diffInDays});
    }

    private String formatInWeeks(int diffInDays) {
        int numberOfWeeks = diffInDays / 7;
        if (numberOfWeeks <= 1) {
            return this.translationService.getTranslation("OneWeekAgo");
        }
        return this.translationService.format("WeeksAgo", new Object[]{numberOfWeeks});
    }
}

