/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.example;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.widgets.example.ExampleProjectWidget;

@Templated
public class ExampleProjectView
implements ExampleProjectWidget.View {
    private ExampleProjectWidget presenter;
    @Inject
    private TranslationService ts;
    @Inject
    @DataField(value="card")
    private HTMLDivElement card;
    @Inject
    @Named(value="h2")
    @DataField(value="name")
    private HTMLElement name;
    @Inject
    @Named(value="h5")
    @DataField(value="description")
    private HTMLElement description;
    @Inject
    @Named(value="div")
    @DataField(value="errors")
    private HTMLDivElement errors;
    @Inject
    @Named(value="span")
    @DataField(value="branch-selector")
    private HTMLElement branchSelector;

    public void init(ExampleProjectWidget presenter) {
        this.presenter = presenter;
        this.branchSelector.title = this.ts.format("BranchSelectorClickToSelectBranches", new Object[0]);
    }

    @Override
    public void setup(String name, String description, HTMLElement errors) {
        this.setup(name, description, errors, false);
    }

    @Override
    public void setup(String name, String description, HTMLElement errors, boolean showBranchSelector) {
        this.name.textContent = name;
        this.description.textContent = description;
        this.description.title = description;
        this.errors.appendChild((Node)errors);
        this.branchSelector.hidden = !showBranchSelector;
    }

    @Override
    public void setActive() {
        this.card.classList.add(new String[]{"active"});
    }

    @Override
    public void unsetActive() {
        this.card.classList.remove(new String[]{"active"});
    }

    @Override
    public void setDisabled() {
        this.card.classList.add(new String[]{"disabled"});
    }

    @Override
    public void changeBranchSelectorTitle(List<String> branches) {
        this.branchSelector.title = this.ts.format("BranchSelectorSelectedBranches", new Object[]{String.join((CharSequence)", ", branches)});
    }

    @EventHandler(value={"card"})
    public void onCardClick(ClickEvent event) {
        this.presenter.click();
    }

    @EventHandler(value={"branch-selector"})
    public void onBranchSelectorClick(ClickEvent event) {
        event.stopPropagation();
        this.presenter.selectBranches();
    }
}

