/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens;

import com.google.gwt.event.dom.client.KeyUpEvent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.PopulatedLibraryScreen;
import org.kie.workbench.common.screens.library.client.widgets.common.TileWidget;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Templated
public class PopulatedLibraryView
implements PopulatedLibraryScreen.View,
IsElement {
    private PopulatedLibraryScreen presenter;
    @Inject
    private TranslationService ts;
    @Inject
    @DataField(value="actions")
    Div actions;
    @Inject
    @DataField(value="project-list")
    Div projectList;
    @Inject
    @DataField(value="filter-text")
    Input filterText;

    public void init(PopulatedLibraryScreen presenter) {
        this.presenter = presenter;
        this.filterText.setAttribute("placeholder", this.ts.getTranslation("Search"));
    }

    @Override
    public void clearProjects() {
        this.projectList.setTextContent("");
    }

    @Override
    public void addProject(TileWidget<WorkspaceProject> project) {
        this.projectList.appendChild((Node)project.getView().getElement());
    }

    @Override
    public void addProject(TileWidget<WorkspaceProject> tileToAdd, TileWidget<WorkspaceProject> tileAfter) {
        this.projectList.insertBefore((Node)tileToAdd.getView().getElement(), (Node)tileAfter.getView().getElement());
    }

    @Override
    public void removeProject(TileWidget<WorkspaceProject> tile) {
        this.projectList.removeChild((Node)tile.getView().getElement());
    }

    @Override
    public void addAction(HTMLElement action) {
        this.actions.appendChild((Node)action);
    }

    @Override
    public void clearFilterText() {
        this.filterText.setValue("");
    }

    @EventHandler(value={"filter-text"})
    public void filterTextChange(KeyUpEvent event) {
        this.presenter.filterProjects(this.filterText.getValue());
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

