/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.assets;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLLabelElement;
import elemental2.dom.Node;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.EmptyState;
import org.kie.workbench.common.screens.library.client.screens.assets.PopulatedAssetsScreen;
import org.kie.workbench.common.screens.library.client.widgets.project.AssetItemWidget;
import org.uberfire.ext.widgets.common.client.select.SelectComponent;
import org.uberfire.ext.widgets.common.client.select.SelectOption;

@Templated
public class PopulatedAssetsView
implements PopulatedAssetsScreen.View,
IsElement {
    @Inject
    @DataField(value="indexing-info")
    private HTMLDivElement indexingInfo;
    @Inject
    @DataField(value="assets-list")
    private HTMLDivElement assetsList;
    @Inject
    @DataField(value="filter-type")
    private HTMLDivElement filterType;
    @Inject
    @DataField(value="filter-text")
    private HTMLInputElement filterText;
    @Inject
    @DataField(value="search")
    private HTMLButtonElement search;
    @Inject
    @DataField(value="page-indicator")
    private HTMLLabelElement pageIndicator;
    @Inject
    @DataField(value="total-pages")
    @Named(value="span")
    private HTMLElement totalPages;
    @Inject
    @DataField(value="current-page")
    private HTMLInputElement currentPage;
    @Inject
    @DataField(value="prev-page")
    private HTMLButtonElement prevPage;
    @Inject
    @DataField(value="next-page")
    private HTMLButtonElement nextPage;
    @Inject
    @DataField(value="import-asset")
    private HTMLButtonElement importAsset;
    @Inject
    @DataField(value="add-asset")
    private HTMLButtonElement addAsset;
    @Inject
    private TranslationService ts;
    @Inject
    private SelectComponent selectComponent;
    @Inject
    private Elemental2DomUtil domUtil;
    private PopulatedAssetsScreen presenter;

    public void init(PopulatedAssetsScreen presenter) {
        this.presenter = presenter;
    }

    @Override
    public void addAssetItem(AssetItemWidget item) {
        this.assetsList.appendChild((Node)this.domUtil.asHTMLElement(item.getElement()));
    }

    @EventHandler(value={"add-asset"})
    public void addAsset(ClickEvent event) {
        this.presenter.addAsset();
    }

    @EventHandler(value={"import-asset"})
    public void importAsset(ClickEvent event) {
        this.presenter.importAsset();
    }

    @EventHandler(value={"next-page"})
    public void nextPage(ClickEvent event) {
        this.presenter.nextPage();
    }

    @EventHandler(value={"prev-page"})
    public void prevPage(ClickEvent event) {
        this.presenter.prevPage();
    }

    @EventHandler(value={"search"})
    public void search(ClickEvent event) {
        this.doSearch();
    }

    @EventHandler(value={"filter-text"})
    public void search(KeyUpEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.doSearch();
        }
    }

    private void doSearch() {
        this.presenter.setCurrentPage(1);
        this.presenter.search(this.filterText.value);
    }

    @EventHandler(value={"current-page"})
    public void currentPageTextChange(KeyUpEvent event) {
        String pageNumber = this.currentPage.value;
        if (pageNumber.matches("\\d+")) {
            this.presenter.setCurrentPage(Integer.valueOf(pageNumber));
        }
    }

    @Override
    public void showEmptyState(EmptyState emptyState) {
        this.indexingInfo.className = "blank-slate-pf";
        this.indexingInfo.innerHTML = emptyState.getElement().getOuterHTML();
    }

    @Override
    public void hideEmptyState(EmptyState emptyState) {
        emptyState.clear();
        this.indexingInfo.className = "";
        this.indexingInfo.innerHTML = "";
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.currentPage.value = String.valueOf(currentPage);
    }

    @Override
    public void setPageIndicator(int from, int to, int total) {
        this.pageIndicator.textContent = from + "-" + to + " " + this.ts.getTranslation("Of") + " " + total;
    }

    @Override
    public void setTotalPages(int totalPages) {
        this.totalPages.textContent = String.valueOf(totalPages);
    }

    @Override
    public void clear() {
        this.domUtil.removeAllElementChildren((Node)this.assetsList);
    }

    @Override
    public void enablePreviousButton() {
        this.prevPage.disabled = false;
    }

    @Override
    public void disablePreviousButton() {
        this.prevPage.disabled = true;
    }

    @Override
    public void enableNextButton() {
        this.nextPage.disabled = false;
    }

    @Override
    public void disableNextButton() {
        this.nextPage.disabled = true;
    }

    @Override
    public void setCategories(List<SelectOption> categories) {
        this.selectComponent.setup(categories, selectOption -> this.presenter.setFilterType(selectOption.getSelector()));
        this.filterType.appendChild((Node)this.selectComponent.getView().getElement());
    }

    @Override
    public void enableImportButton(boolean enable) {
        this.importAsset.disabled = !enable;
    }

    @Override
    public void enableAddAssetButton(boolean enable) {
        this.addAsset.disabled = !enable;
    }
}

