/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.importrepository;

import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.screens.examples.model.Credentials;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.examples.service.ProjectImportService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

public class ImportRepositoryPopUpPresenter {
    private View view;
    private Caller<ProjectImportService> importService;
    private LibraryPlaces libraryPlaces;

    @Inject
    public ImportRepositoryPopUpPresenter(View view, LibraryPlaces libraryPlaces, Caller<ProjectImportService> importService) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.importService = importService;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show() {
        this.view.show();
    }

    public void importRepository() {
        String repositoryUrl = this.view.getRepositoryURL();
        if (this.isEmpty(repositoryUrl)) {
            this.view.showError(this.view.getEmptyRepositoryURLValidationMessage());
            return;
        }
        this.view.showBusyIndicator(this.view.getLoadingMessage());
        ((ProjectImportService)this.importService.call(projects -> {
            this.view.hideBusyIndicator();
            if (projects.isEmpty()) {
                this.view.showError(this.view.getNoProjectsToImportMessage());
            } else {
                this.view.hide();
                this.libraryPlaces.goToExternalImportPresenter((Set<ImportProject>)projects);
            }
        }, (message, throwable) -> {
            this.view.hideBusyIndicator();
            this.view.showError(this.view.getNoProjectsToImportMessage());
            return false;
        })).getProjects(this.libraryPlaces.getActiveSpace(), new ExampleRepository(repositoryUrl.trim(), new Credentials(this.view.getUserName(), this.view.getPassword())));
    }

    public void cancel() {
        this.view.hide();
    }

    public View getView() {
        return this.view;
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static interface View
    extends UberElement<ImportRepositoryPopUpPresenter>,
    HasBusyIndicator {
        public String getRepositoryURL();

        public String getUserName();

        public String getPassword();

        public void show();

        public void hide();

        public void showError(String var1);

        public String getLoadingMessage();

        public String getNoProjectsToImportMessage();

        public String getEmptyRepositoryURLValidationMessage();
    }
}

