/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.Node;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListItemPresenter;
import org.uberfire.client.views.pfly.widgets.InputAutocomplete;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Templated
public class ContributorsListItemView
implements ContributorsListItemPresenter.View,
IsElement {
    @Inject
    private TranslationService ts;
    private ContributorsListItemPresenter presenter;
    @Inject
    @DataField(value="container")
    HTMLDivElement container;
    @Inject
    @Named(value="span")
    @DataField(value="name")
    HTMLElement name;
    @Inject
    @Named(value="span")
    @DataField(value="role")
    HTMLElement role;
    @Inject
    @DataField(value="name-input-container")
    HTMLDivElement nameInputContainer;
    @Inject
    @DataField(value="role-select")
    HTMLSelectElement roleSelect;
    @Inject
    @DataField(value="edit")
    HTMLAnchorElement edit;
    @Inject
    @DataField(value="remove")
    HTMLAnchorElement remove;
    @Inject
    @DataField(value="ok")
    HTMLButtonElement ok;
    @Inject
    @DataField(value="cancel")
    HTMLButtonElement cancel;
    @Inject
    InputAutocomplete nameInput;

    public void init(ContributorsListItemPresenter presenter) {
        this.presenter = presenter;
        this.setupUsersAutocomplete();
    }

    private void setupUsersAutocomplete() {
        this.nameInput.setup(this.presenter::getUserNames);
        this.nameInputContainer.appendChild((Node)this.nameInput.getElement());
    }

    @Override
    public void setupAddMode() {
        this.editMode();
    }

    @Override
    public void setupViewMode(Contributor contributor) {
        this.name.innerHTML = contributor.getUsername();
        this.role.innerHTML = this.getRoleLabel(contributor.getType());
        this.viewMode();
    }

    @Override
    public void removeContributor() {
        for (int i = this.container.childNodes.getLength() - 1; i > 0; --i) {
            this.container.removeChild((Node)this.container.childNodes.item((double)i));
        }
    }

    @Override
    public String getName() {
        return this.nameInput.getValue();
    }

    @Override
    public ContributorType getRole() {
        return ContributorType.valueOf((String)this.roleSelect.value);
    }

    @Override
    public String getSavingMessage() {
        return this.ts.format("Saving", new Object[0]);
    }

    @Override
    public String getSaveSuccessMessage() {
        return this.ts.format("EditOrganizationalUnitContributorsSaveSuccess", new Object[0]);
    }

    @Override
    public String getEmptyNameMessage() {
        return this.ts.format("EmptyName", new Object[0]);
    }

    @Override
    public String getInvalidRoleMessage() {
        return this.ts.format("EmptyFieldValidation", new Object[]{"Role"});
    }

    @Override
    public String getRemoveSuccessMessage() {
        return this.ts.format("EditOrganizationalUnitContributorsRemoveSuccess", new Object[0]);
    }

    @Override
    public String getSpaceOwnerChangedMessage() {
        return this.ts.format("SpaceOwnerChanged", new Object[0]);
    }

    @Override
    public String getSingleOwnerIsMandatoryMessage() {
        return this.ts.format("SingleOwnerIsMandatory", new Object[0]);
    }

    @Override
    public String getDuplicatedContributorMessage() {
        return this.ts.format("DuplicatedContributor", new Object[0]);
    }

    @Override
    public String getContributorTypeNotAllowedMessage() {
        return this.ts.format("ContributorTypeNotAllowed", new Object[0]);
    }

    @Override
    public String getTranslation(String key) {
        return this.ts.format(key, new Object[0]);
    }

    @Override
    public void showActions() {
        this.presenter.canEditContributors().then(canEditContributors -> {
            this.edit.hidden = canEditContributors == false;
            return this.presenter.promises.resolve();
        });
        this.presenter.canRemoveContributor().then(canRemoveContributor -> {
            this.remove.hidden = canRemoveContributor == false;
            return this.presenter.promises.resolve();
        });
    }

    @Override
    public void hideActions() {
        this.edit.hidden = true;
        this.remove.hidden = true;
    }

    @EventHandler(value={"edit"})
    public void edit(ClickEvent clickEvent) {
        this.presenter.edit();
        this.nameInput.setValue(this.presenter.getContributor().getUsername());
        this.roleSelect.value = this.presenter.getContributor().getType().name();
    }

    @EventHandler(value={"remove"})
    public void remove(ClickEvent clickEvent) {
        this.presenter.remove();
    }

    @EventHandler(value={"ok"})
    public void ok(ClickEvent clickEvent) {
        this.presenter.save();
    }

    @EventHandler(value={"cancel"})
    public void cancel(ClickEvent clickEvent) {
        this.presenter.cancel();
    }

    @Override
    public void viewMode() {
        this.name.hidden = false;
        this.role.hidden = false;
        this.nameInput.getElement().hidden = true;
        this.roleSelect.hidden = true;
        this.showActions();
        this.ok.hidden = true;
        this.cancel.hidden = true;
    }

    @Override
    public void editMode() {
        this.name.hidden = true;
        this.role.hidden = true;
        this.nameInput.getElement().hidden = false;
        this.roleSelect.hidden = false;
        this.hideActions();
        this.ok.hidden = false;
        this.cancel.hidden = false;
    }

    public String getRoleLabel(ContributorType role) {
        if (ContributorType.OWNER.equals((Object)role)) {
            return this.ts.format("ContributorTypeOwner", new Object[0]);
        }
        if (ContributorType.ADMIN.equals((Object)role)) {
            return this.ts.format("ContributorTypeAdmin", new Object[0]);
        }
        if (ContributorType.CONTRIBUTOR.equals((Object)role)) {
            return this.ts.format("ContributorTypeContributor", new Object[0]);
        }
        return role.name();
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

