/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.diff;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.CSSProperties;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.diff.DiffItemPresenter;
import org.uberfire.ext.widgets.common.client.diff2html.Diff2Html;
import org.uberfire.ext.widgets.common.client.diff2html.DiffOutputFormat;

@Dependent
@Templated
public class DiffItemView
implements DiffItemPresenter.View,
IsElement {
    private static final String SIZE_100P = "100%";
    private static final int DIFF_CONTAINER_HEIGHT = 396;
    private static final String DIFF_CONTAINER_HEIGHT_PX = "396px";
    private static int nextId = 0;
    private DiffItemPresenter presenter;
    @Inject
    @DataField(value="conflict-label")
    @Named(value="span")
    private HTMLElement conflictLabel;
    @Inject
    @DataField(value="change-type")
    @Named(value="span")
    private HTMLElement changeType;
    @Inject
    @DataField(value="filename")
    @Named(value="span")
    private HTMLElement filename;
    @Inject
    @DataField(value="collapse-container")
    private HTMLDivElement collapseContainer;
    @Inject
    @DataField(value="collapse-link")
    private HTMLAnchorElement collapseLink;
    @Inject
    @DataField(value="textual-diff-container")
    private HTMLDivElement textualDiffContainer;
    @Inject
    @DataField(value="custom-diff-container")
    private HTMLDivElement customDiffContainer;
    @Inject
    @DataField(value="left-container")
    private HTMLDivElement customLeftContainer;
    @Inject
    @DataField(value="right-container")
    private HTMLDivElement customRightContainer;
    @Inject
    @DataField(value="unmodified-file")
    private HTMLDivElement unmodifiedFile;
    @Inject
    @DataField(value="binary-file")
    private HTMLDivElement binaryFile;
    @Inject
    private Elemental2DomUtil domUtil;
    private Diff2Html diff2Html;

    public void init(DiffItemPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setupTextualContent(String filename, String changeType, boolean conflict) {
        this.setup(filename, changeType, conflict);
        this.textualDiffContainer.hidden = false;
    }

    @Override
    public void setupCustomContent(String filename, String changeType, boolean conflict) {
        this.setup(filename, changeType, conflict);
        this.customDiffContainer.hidden = false;
    }

    @Override
    public HTMLElement getCustomLeftContainer() {
        return this.customLeftContainer;
    }

    @Override
    public HTMLElement getCustomRightContainer() {
        return this.customRightContainer;
    }

    @Override
    public void clearCustomLeftContainer() {
        this.domUtil.removeAllElementChildren((Node)this.customLeftContainer);
    }

    @Override
    public void clearCustomRightContainer() {
        this.domUtil.removeAllElementChildren((Node)this.customRightContainer);
    }

    @Override
    public void expandCollapsibleContainer(boolean isOpened) {
        if (isOpened) {
            this.collapseLink.classList.remove(new String[]{"collapsed"});
            this.collapseContainer.classList.add(new String[]{"in"});
            this.collapseContainer.setAttribute("aria-expanded", String.valueOf(true));
        } else {
            this.collapseLink.classList.add(new String[]{"collapsed"});
            this.collapseContainer.classList.remove(new String[]{"in"});
            this.collapseContainer.setAttribute("aria-expanded", String.valueOf(false));
        }
    }

    @Override
    public void drawBinaryContent() {
        this.binaryFile.hidden = false;
    }

    @Override
    public void drawUnmodifiedContent() {
        this.unmodifiedFile.hidden = false;
    }

    @Override
    public void removeTextualContent() {
        if (this.diff2Html != null) {
            this.domUtil.removeAllElementChildren((Node)this.textualDiffContainer);
            this.diff2Html = null;
        }
    }

    @Override
    public void removeCollapseLink() {
        this.collapseLink.href = "";
        this.collapseLink.style.cursor = "auto";
    }

    @Override
    public void drawTextualContent(String diffText, boolean isUnified) {
        if (this.diff2Html == null) {
            this.diff2Html = new Diff2Html(this.textualDiffContainer.id, isUnified ? DiffOutputFormat.LINE_BY_LINE : DiffOutputFormat.SIDE_BY_SIDE, diffText);
            this.diff2Html.draw();
            this.diff2Html.configContainerHeight(396);
        }
    }

    @Override
    public void expandCustomLeftContainer() {
        this.customLeftContainer.hidden = false;
        this.customLeftContainer.style.width = CSSProperties.WidthUnionType.of((Object)SIZE_100P);
        this.customRightContainer.hidden = true;
    }

    @Override
    public void expandCustomRightContainer() {
        this.customLeftContainer.hidden = true;
        this.customRightContainer.hidden = false;
        this.customRightContainer.style.width = CSSProperties.WidthUnionType.of((Object)SIZE_100P);
    }

    @EventHandler(value={"collapse-link"})
    public void onCollapseLinkClicked(ClickEvent event) {
        if (!this.collapseLink.href.equals("")) {
            this.presenter.toggleCollapsibleContainerState();
        }
    }

    private void setup(String filename, String changeType, boolean conflict) {
        String elementId = "_" + DiffItemView.class.getSimpleName() + "GWT" + nextId++;
        String containerId = "_collapsible-container" + elementId;
        this.filename.textContent = filename;
        this.changeType.textContent = changeType + " - ";
        this.textualDiffContainer.id = "_textual-diff-container" + elementId;
        this.textualDiffContainer.style.maxHeight = CSSProperties.MaxHeightUnionType.of((Object)DIFF_CONTAINER_HEIGHT_PX);
        this.customDiffContainer.id = "_custom-diff-container" + elementId;
        this.customLeftContainer.style.height = CSSProperties.HeightUnionType.of((Object)DIFF_CONTAINER_HEIGHT_PX);
        this.customRightContainer.style.height = CSSProperties.HeightUnionType.of((Object)DIFF_CONTAINER_HEIGHT_PX);
        this.textualDiffContainer.hidden = true;
        this.customDiffContainer.hidden = true;
        this.binaryFile.hidden = true;
        this.unmodifiedFile.hidden = true;
        this.collapseContainer.id = containerId;
        this.collapseLink.href = "#" + containerId;
        this.conflictLabel.hidden = !conflict;
    }
}

