/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.review;

import elemental2.dom.HTMLElement;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequest;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestAlreadyOpenException;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatus;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatusUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.NothingToMergeException;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.api.RepositoryFileListUpdatedEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.review.tab.changedfiles.ChangedFilesScreenPresenter;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.review.tab.overview.OverviewScreenPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;

@WorkbenchScreen(identifier="ChangeRequestReviewScreen", owningPerspective=LibraryPerspective.class)
public class ChangeRequestReviewScreenPresenter {
    private final View view;
    private final TranslationService ts;
    private final LibraryPlaces libraryPlaces;
    private final Caller<ChangeRequestService> changeRequestService;
    private final Caller<RepositoryService> repositoryService;
    private final BusyIndicatorView busyIndicatorView;
    private final OverviewScreenPresenter overviewScreen;
    private final ChangedFilesScreenPresenter changedFilesScreen;
    private final Promises promises;
    private final ProjectController projectController;
    private final Event<NotificationEvent> notificationEvent;
    private final SessionInfo sessionInfo;
    private WorkspaceProject workspaceProject;
    private long currentChangeRequestId;
    private Branch currentSourceBranch;
    private Branch currentTargetBranch;
    private boolean overviewTabLoaded;
    private boolean changedFilesTabLoaded;
    private Repository repository;
    private String authorId;

    @Inject
    public ChangeRequestReviewScreenPresenter(View view, TranslationService ts, LibraryPlaces libraryPlaces, Caller<ChangeRequestService> changeRequestService, Caller<RepositoryService> repositoryService, BusyIndicatorView busyIndicatorView, OverviewScreenPresenter overviewScreen, ChangedFilesScreenPresenter changedFilesScreen, Promises promises, ProjectController projectController, Event<NotificationEvent> notificationEvent, SessionInfo sessionInfo) {
        this.view = view;
        this.ts = ts;
        this.libraryPlaces = libraryPlaces;
        this.changeRequestService = changeRequestService;
        this.repositoryService = repositoryService;
        this.busyIndicatorView = busyIndicatorView;
        this.overviewScreen = overviewScreen;
        this.changedFilesScreen = changedFilesScreen;
        this.promises = promises;
        this.projectController = projectController;
        this.notificationEvent = notificationEvent;
        this.sessionInfo = sessionInfo;
    }

    @PostConstruct
    public void postConstruct() {
        this.workspaceProject = this.libraryPlaces.getActiveWorkspace();
        this.repository = this.workspaceProject.getRepository();
        this.view.init(this);
        this.view.setTitle(this.getTitle());
    }

    public void refreshOnFocus(@Observes SelectPlaceEvent selectPlaceEvent) {
        String changeRequestIdValue;
        PlaceRequest place;
        if (this.workspaceProject != null && this.workspaceProject.getMainModule() != null && (place = selectPlaceEvent.getPlace()).getIdentifier().equals("ChangeRequestReviewScreen") && (changeRequestIdValue = place.getParameter("CHANGE_REQUEST_ID", null)) != null && !changeRequestIdValue.equals("")) {
            this.currentChangeRequestId = Long.parseLong(changeRequestIdValue);
            this.loadContent();
        }
    }

    public void onChangeRequestUpdated(@Observes ChangeRequestUpdatedEvent event) {
        if (event.getRepositoryId().equals(this.repository.getIdentifier()) && event.getChangeRequestId() == this.currentChangeRequestId) {
            this.refreshContent(true, false);
            this.notifyOtherUsers(event.getUserId());
        }
    }

    public void onChangeRequestStatusUpdated(@Observes ChangeRequestStatusUpdatedEvent event) {
        if (event.getRepositoryId().equals(this.repository.getIdentifier()) && event.getChangeRequestId() == this.currentChangeRequestId) {
            boolean refreshChangedFiles = event.getNewStatus() == ChangeRequestStatus.OPEN;
            this.refreshContent(true, refreshChangedFiles);
            this.notifyOtherUsers(event.getUserId());
        }
    }

    public void onRepositoryFileListUpdated(@Observes RepositoryFileListUpdatedEvent event) {
        if (event.getRepositoryId().equals(this.repository.getIdentifier())) {
            String updatedBranch = event.getBranchName();
            if (this.currentSourceBranch.getName().equals(updatedBranch) || this.currentTargetBranch.getName().equals(updatedBranch)) {
                this.refreshContent(false, true);
            }
        }
    }

    public void onRepositoryUpdated(@Observes RepositoryUpdatedEvent event) {
        if (event.getRepository().getIdentifier().equals(this.repository.getIdentifier())) {
            this.repository = event.getRepository();
            if (!this.repository.getBranches().contains(this.currentSourceBranch) || !this.repository.getBranches().contains(this.currentTargetBranch)) {
                this.goBackToProject();
            }
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.ts.getTranslation("ChangeRequest");
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    public void showOverviewContent() {
        this.view.setContent(this.overviewScreen.getView().getElement());
    }

    public void showChangedFilesContent() {
        this.view.setContent(this.changedFilesScreen.getView().getElement());
    }

    public void cancel() {
        this.goBackToProject();
    }

    public void reject() {
        this.doActionIfAllowed(this::rejectChangeRequestAction);
    }

    public void accept() {
        this.doActionIfAllowed(this::acceptChangeRequestAction);
    }

    public void revert() {
        this.doActionIfAllowed(this::revertChangeRequestAction);
    }

    public void close() {
        if (this.isUserAuthor()) {
            this.closeChangeRequestAction();
        }
    }

    public void reopen() {
        if (this.isUserAuthor()) {
            this.reopenChangeRequestAction();
        }
    }

    private void notifyOtherUsers(String userWhoMadeUpdates) {
        if (!this.sessionInfo.getIdentity().getIdentifier().equals(userWhoMadeUpdates)) {
            this.fireNotificationEvent(this.ts.format("ChangeRequestUpdatedMessage", new Object[]{this.currentChangeRequestId, userWhoMadeUpdates}), NotificationEvent.NotificationType.INFO);
        }
    }

    private void goBackToProject() {
        this.reset();
        this.libraryPlaces.closeChangeRequestReviewScreen();
        this.libraryPlaces.goToProject(this.workspaceProject);
    }

    private void doActionIfAllowed(Runnable action) {
        this.projectController.canUpdateBranch(this.workspaceProject, this.currentTargetBranch).then(userCanUpdateBranch -> {
            if (Boolean.TRUE.equals(userCanUpdateBranch)) {
                action.run();
            }
            return this.promises.resolve();
        });
    }

    private void loadContent() {
        this.reset();
        this.view.setTitle(this.ts.format("ChangeRequestAndId", new Object[]{this.currentChangeRequestId}));
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("Loading"));
        ((RepositoryService)this.repositoryService.call(updatedRepository -> {
            this.repository = updatedRepository;
            this.setup(this.loadChangeRequestCallback());
        })).getRepositoryFromSpace(this.workspaceProject.getSpace(), this.repository.getAlias());
    }

    private void refreshContent(boolean refreshOverview, boolean refreshChangedFiles) {
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("Loading"));
        this.setup(this.reloadChangeRequestCallback(refreshOverview, refreshChangedFiles));
    }

    private void reset() {
        this.overviewTabLoaded = false;
        this.changedFilesTabLoaded = false;
        this.overviewScreen.reset();
        this.changedFilesScreen.reset();
        this.view.resetAll();
        this.view.activateOverviewTab();
    }

    private void setup(RemoteCallback<ChangeRequest> getChangeRequestCallback) {
        ((ChangeRequestService)this.changeRequestService.call(getChangeRequestCallback, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).getChangeRequest(this.workspaceProject.getSpace().getName(), this.repository.getAlias(), Long.valueOf(this.currentChangeRequestId));
    }

    private RemoteCallback<ChangeRequest> loadChangeRequestCallback() {
        return changeRequest -> {
            this.authorId = changeRequest.getAuthorId();
            this.resolveInvolvedBranches((ChangeRequest)changeRequest);
            this.setupOverviewScreen((ChangeRequest)changeRequest);
            this.setupChangedFilesScreen((ChangeRequest)changeRequest);
        };
    }

    private void resolveInvolvedBranches(ChangeRequest changeRequest) {
        this.currentSourceBranch = (Branch)this.repository.getBranch(changeRequest.getSourceBranch()).orElseThrow(() -> new IllegalArgumentException("The branch " + changeRequest.getSourceBranch() + " does not exist."));
        this.currentTargetBranch = (Branch)this.repository.getBranch(changeRequest.getTargetBranch()).orElseThrow(() -> new IllegalStateException("The branch " + changeRequest.getTargetBranch() + " does not exist."));
    }

    private void setupOverviewScreen(ChangeRequest changeRequest) {
        this.overviewScreen.setup(changeRequest, success -> {
            this.overviewTabLoaded = true;
            this.finishLoading(changeRequest);
        });
    }

    private void setupChangedFilesScreen(ChangeRequest changeRequest) {
        this.changedFilesScreen.setup(changeRequest, success -> {
            this.changedFilesTabLoaded = true;
            this.finishLoading(changeRequest);
        }, this.view::setChangedFilesCount);
    }

    private RemoteCallback<ChangeRequest> reloadChangeRequestCallback(boolean refreshOverview, boolean refreshChangedFiles) {
        return changeRequest -> {
            if (refreshOverview) {
                this.overviewTabLoaded = false;
                this.setupOverviewScreen((ChangeRequest)changeRequest);
            } else {
                this.overviewTabLoaded = true;
            }
            if (changeRequest.getStatus() == ChangeRequestStatus.OPEN && refreshChangedFiles) {
                this.changedFilesTabLoaded = false;
                this.setupChangedFilesScreen((ChangeRequest)changeRequest);
            } else {
                this.changedFilesTabLoaded = true;
            }
        };
    }

    private void setupActionButtons(ChangeRequest changeRequest, Branch targetBranch) {
        this.projectController.canUpdateBranch(this.workspaceProject, targetBranch).then(userCanUpdateBranch -> {
            this.view.resetButtonState();
            switch (changeRequest.getStatus()) {
                case ACCEPTED: {
                    this.view.showRevertButton((boolean)userCanUpdateBranch);
                    break;
                }
                case OPEN: {
                    boolean canBeAccepted = userCanUpdateBranch != false && changeRequest.isConflict() == false && changeRequest.getChangedFilesCount() > 0;
                    this.view.showRejectButton((boolean)userCanUpdateBranch);
                    this.view.showAcceptButton((boolean)userCanUpdateBranch);
                    this.view.enableAcceptButton(canBeAccepted);
                    this.view.showCloseButton(this.isUserAuthor());
                    break;
                }
                case REJECTED: 
                case CLOSED: {
                    this.view.showReopenButton(this.isUserAuthor());
                    break;
                }
            }
            return this.promises.resolve();
        });
    }

    private void rejectChangeRequestAction() {
        ((ChangeRequestService)this.changeRequestService.call(v -> this.fireNotificationEvent(this.ts.format("ChangeRequestRejectMessage", new Object[]{this.currentChangeRequestId}), NotificationEvent.NotificationType.SUCCESS))).rejectChangeRequest(this.workspaceProject.getSpace().getName(), this.repository.getAlias(), Long.valueOf(this.currentChangeRequestId));
    }

    private void acceptChangeRequestAction() {
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("Loading"));
        ((ChangeRequestService)this.changeRequestService.call(succeeded -> {
            if (Boolean.TRUE.equals(succeeded)) {
                this.fireNotificationEvent(this.ts.format("ChangeRequestAcceptMessage", new Object[]{this.currentChangeRequestId}), NotificationEvent.NotificationType.SUCCESS);
            }
            this.busyIndicatorView.hideBusyIndicator();
        }, this.acceptChangeRequestErrorCallback())).acceptChangeRequest(this.workspaceProject.getSpace().getName(), this.repository.getAlias(), Long.valueOf(this.currentChangeRequestId));
    }

    private ErrorCallback<Object> acceptChangeRequestErrorCallback() {
        return (message, throwable) -> {
            this.busyIndicatorView.hideBusyIndicator();
            if (throwable instanceof NothingToMergeException) {
                this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("NothingToMergeMessage"), NotificationEvent.NotificationType.WARNING));
                return false;
            }
            return true;
        };
    }

    private void revertChangeRequestAction() {
        ((ChangeRequestService)this.changeRequestService.call(succeeded -> {
            if (Boolean.TRUE.equals(succeeded)) {
                this.fireNotificationEvent(this.ts.format("ChangeRequestRevertMessage", new Object[]{this.currentChangeRequestId}), NotificationEvent.NotificationType.SUCCESS);
            } else {
                this.fireNotificationEvent(this.ts.format("ChangeRequestRevertFailMessage", new Object[]{this.currentChangeRequestId}), NotificationEvent.NotificationType.WARNING);
            }
        })).revertChangeRequest(this.workspaceProject.getSpace().getName(), this.repository.getAlias(), Long.valueOf(this.currentChangeRequestId));
    }

    private void closeChangeRequestAction() {
        ((ChangeRequestService)this.changeRequestService.call(v -> this.fireNotificationEvent(this.ts.format("ChangeRequestCloseMessage", new Object[]{this.currentChangeRequestId}), NotificationEvent.NotificationType.SUCCESS))).closeChangeRequest(this.workspaceProject.getSpace().getName(), this.repository.getAlias(), Long.valueOf(this.currentChangeRequestId));
    }

    private void reopenChangeRequestAction() {
        ((ChangeRequestService)this.changeRequestService.call(v -> this.fireNotificationEvent(this.ts.format("ChangeRequestReopenMessage", new Object[]{this.currentChangeRequestId}), NotificationEvent.NotificationType.SUCCESS), this.reopenChangeRequestErrorCallback())).reopenChangeRequest(this.workspaceProject.getSpace().getName(), this.repository.getAlias(), Long.valueOf(this.currentChangeRequestId));
    }

    private ErrorCallback<Object> reopenChangeRequestErrorCallback() {
        return (message, throwable) -> {
            this.busyIndicatorView.hideBusyIndicator();
            if (throwable instanceof ChangeRequestAlreadyOpenException) {
                Long changeRequestId = ((ChangeRequestAlreadyOpenException)throwable).getChangeRequestId();
                this.notificationEvent.fire((Object)new NotificationEvent(this.ts.format("ChangeRequestAlreadyOpenMessage", new Object[]{changeRequestId, this.currentSourceBranch.getName(), this.currentTargetBranch.getName()}), NotificationEvent.NotificationType.WARNING));
                return false;
            }
            return true;
        };
    }

    private void fireNotificationEvent(String message, NotificationEvent.NotificationType type) {
        this.notificationEvent.fire((Object)new NotificationEvent(message, type));
    }

    private void finishLoading(ChangeRequest changeRequest) {
        if (this.overviewTabLoaded && this.changedFilesTabLoaded) {
            this.setupActionButtons(changeRequest, this.currentTargetBranch);
            this.overviewScreen.checkWarnConflict(changeRequest);
            this.busyIndicatorView.hideBusyIndicator();
        }
    }

    private boolean isUserAuthor() {
        return this.authorId.equals(this.sessionInfo.getIdentity().getIdentifier());
    }

    public static interface View
    extends UberElemental<ChangeRequestReviewScreenPresenter> {
        public void setTitle(String var1);

        public void setChangedFilesCount(int var1);

        public void setContent(HTMLElement var1);

        public void showRejectButton(boolean var1);

        public void showAcceptButton(boolean var1);

        public void enableAcceptButton(boolean var1);

        public void showRevertButton(boolean var1);

        public void showCloseButton(boolean var1);

        public void showReopenButton(boolean var1);

        public void activateOverviewTab();

        public void activateChangedFilesTab();

        public void resetButtonState();

        public void resetAll();
    }
}

