/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.review;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.Node;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.review.ChangeRequestReviewScreenPresenter;

@Templated
public class ChangeRequestReviewScreenView
implements ChangeRequestReviewScreenPresenter.View,
IsElement {
    private static final String ACTIVE = "active";
    private ChangeRequestReviewScreenPresenter presenter;
    @Inject
    @DataField(value="title")
    private HTMLDivElement title;
    @Inject
    @DataField(value="overview-tab-link")
    private HTMLAnchorElement overviewTabLink;
    @Inject
    @DataField(value="overview-tab")
    private HTMLLIElement overviewTabItem;
    @Inject
    @DataField(value="changed-files-tab-link")
    private HTMLAnchorElement changedFilesTabLink;
    @Inject
    @DataField(value="changed-files-tab")
    private HTMLLIElement changedFilesTabItem;
    @Inject
    @Named(value="span")
    @DataField(value="changed-files-count-badge")
    private HTMLElement changedFilesCountBadge;
    @Inject
    @DataField(value="cancel-button")
    private HTMLButtonElement cancelButton;
    @Inject
    @DataField(value="reject-button")
    private HTMLButtonElement rejectButton;
    @Inject
    @DataField(value="close-button")
    private HTMLButtonElement closeButton;
    @Inject
    @DataField(value="reopen-button")
    private HTMLButtonElement reopenButton;
    @Inject
    @DataField(value="accept-button")
    private HTMLButtonElement acceptButton;
    @Inject
    @DataField(value="revert-button")
    private HTMLButtonElement revertButton;
    @Inject
    @DataField(value="main-container")
    private HTMLDivElement mainContainer;
    @Inject
    private Elemental2DomUtil domUtil;

    public void init(ChangeRequestReviewScreenPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setTitle(String title) {
        this.title.textContent = title;
    }

    @Override
    public void setChangedFilesCount(int count) {
        this.changedFilesCountBadge.textContent = String.valueOf(count);
    }

    @Override
    public void setContent(HTMLElement content) {
        this.domUtil.removeAllElementChildren((Node)this.mainContainer);
        this.mainContainer.appendChild((Node)content);
    }

    @Override
    public void showRejectButton(boolean isVisible) {
        this.rejectButton.hidden = !isVisible;
    }

    @Override
    public void showAcceptButton(boolean isVisible) {
        this.acceptButton.hidden = !isVisible;
    }

    @Override
    public void enableAcceptButton(boolean isEnabled) {
        this.acceptButton.disabled = !isEnabled;
    }

    @Override
    public void showRevertButton(boolean isVisible) {
        this.revertButton.hidden = !isVisible;
    }

    @Override
    public void showCloseButton(boolean isVisible) {
        this.closeButton.hidden = !isVisible;
    }

    @Override
    public void showReopenButton(boolean isVisible) {
        this.reopenButton.hidden = !isVisible;
    }

    @Override
    public void activateOverviewTab() {
        this.deactivateAllTabs();
        this.activate(this.overviewTabItem);
        this.presenter.showOverviewContent();
    }

    @Override
    public void activateChangedFilesTab() {
        this.deactivateAllTabs();
        this.activate(this.changedFilesTabItem);
        this.presenter.showChangedFilesContent();
    }

    @Override
    public void resetAll() {
        this.resetButtonState();
    }

    @Override
    public void resetButtonState() {
        this.showAcceptButton(false);
        this.showRejectButton(false);
        this.showRevertButton(false);
        this.showCloseButton(false);
        this.showReopenButton(false);
        this.enableAcceptButton(true);
    }

    @EventHandler(value={"overview-tab-link"})
    public void onOverviewTabLinkClicked(ClickEvent event) {
        this.activateOverviewTab();
    }

    @EventHandler(value={"changed-files-tab-link"})
    public void onChangedFilesTabLinkClicked(ClickEvent event) {
        this.activateChangedFilesTab();
    }

    @EventHandler(value={"cancel-button"})
    public void onCancelClicked(ClickEvent event) {
        this.presenter.cancel();
    }

    @EventHandler(value={"reject-button"})
    public void onRejectClicked(ClickEvent event) {
        this.presenter.reject();
    }

    @EventHandler(value={"close-button"})
    public void onCloseClicked(ClickEvent event) {
        this.presenter.close();
    }

    @EventHandler(value={"reopen-button"})
    public void onReopenClicked(ClickEvent event) {
        this.presenter.reopen();
    }

    @EventHandler(value={"accept-button"})
    public void onAcceptClicked(ClickEvent event) {
        this.presenter.accept();
    }

    @EventHandler(value={"revert-button"})
    public void onRevertClicked(ClickEvent event) {
        this.presenter.revert();
    }

    private void activate(HTMLLIElement element) {
        element.classList.add(new String[]{ACTIVE});
    }

    private void deactivate(HTMLLIElement element) {
        element.classList.remove(new String[]{ACTIVE});
    }

    private void deactivateAllTabs() {
        this.deactivate(this.overviewTabItem);
        this.deactivate(this.changedFilesTabItem);
    }
}

