/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.common;

import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Heading;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.widgets.common.TileWidget;
import org.uberfire.mvp.Command;

@Templated
public class TileView
implements TileWidget.View,
IsElement {
    private TileWidget presenter;
    @Inject
    private TranslationService ts;
    @Inject
    @DataField(value="card")
    private Div card;
    @Inject
    @Named(value="h2")
    @DataField(value="label")
    private Heading label;
    @Inject
    @Named(value="h5")
    @DataField(value="description")
    private Heading description;
    @Inject
    @DataField(value="circle")
    private Span circle;

    public void init(TileWidget presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setup(String label, String description, Command selectCommand) {
        this.label.setTextContent(label);
        this.description.setTextContent(description);
        this.description.setTitle(description);
        this.card.setOnclick(event -> selectCommand.execute());
        this.circle.setHidden(true);
    }

    @Override
    public void setNumberOfAssets(Integer numberOfAssets) {
        this.circle.setHidden(false);
        this.circle.setTextContent(String.valueOf(numberOfAssets));
        this.circle.setTitle(this.ts.format("NumberOfAssets", new Object[]{numberOfAssets}));
    }

    @Override
    public boolean isSelected() {
        return this.card.getClassList().contains("active");
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected) {
            this.card.getClassList().add("active");
        } else {
            this.card.getClassList().remove("active");
        }
    }
}

