/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.assets;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.library.api.AssetQueryResult;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;

@Dependent
public class AssetQueryService {
    private final Caller<LibraryService> libraryServiceCaller;
    private Object tokenForGetProjectAssets = null;
    private Object tokenForGetNumberOfAssets = null;

    @Inject
    public AssetQueryService(Caller<LibraryService> libraryServiceCaller) {
        this.libraryServiceCaller = libraryServiceCaller;
    }

    public Invoker<AssetQueryResult> getAssets(ProjectAssetsQuery query) {
        return new Invoker<AssetQueryResult>(libraryService -> libraryService.getProjectAssets(query), () -> this.tokenForGetProjectAssets, newToken -> {
            this.tokenForGetProjectAssets = newToken;
        });
    }

    public Invoker<Integer> getNumberOfAssets(ProjectAssetsQuery query) {
        return new Invoker<Integer>(libraryService -> libraryService.getNumberOfAssets(query), () -> this.tokenForGetNumberOfAssets, newToken -> {
            this.tokenForGetNumberOfAssets = newToken;
        });
    }

    public class Invoker<T> {
        private final Function<LibraryService, T> methodCall;
        private final Supplier<Object> activeTokenGetter;
        private final Consumer<Object> activeTokenSetter;

        private Invoker(Function<LibraryService, T> methodCall, Supplier<Object> activeTokenGetter, Consumer<Object> activeTokenSetter) {
            this.methodCall = methodCall;
            this.activeTokenGetter = activeTokenGetter;
            this.activeTokenSetter = activeTokenSetter;
        }

        public void call(RemoteCallback<T> callback, ErrorCallback<Message> errorCallback) {
            Object token = new Object();
            this.activeTokenSetter.accept(token);
            this.methodCall.apply((LibraryService)AssetQueryService.this.libraryServiceCaller.call(this.wrap(token, callback), this.wrap(token, errorCallback)));
        }

        private ErrorCallback<Message> wrap(Object token, ErrorCallback<Message> errorCallback) {
            return (msg, error) -> this.validToken(token) && errorCallback != null && errorCallback.error(msg, error);
        }

        private RemoteCallback<T> wrap(Object token, RemoteCallback<T> callback) {
            return t -> {
                if (this.validToken(token)) {
                    callback.callback(t);
                }
            };
        }

        private boolean validToken(Object token) {
            return token == this.activeTokenGetter.get();
        }
    }
}

