/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.assets;

import com.google.gwt.core.client.Callback;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.kie.workbench.common.screens.defaulteditor.client.editor.NewFileUploader;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;

public class EmptyAssetsScreen {
    private final View view;
    private final NewFileUploader newFileUploader;
    private final NewResourcePresenter newResourcePresenter;
    private final ProjectController projectController;
    private final LibraryPlaces libraryPlaces;
    private final Promises promises;

    @Inject
    public EmptyAssetsScreen(View view, NewFileUploader newFileUploader, NewResourcePresenter newResourcePresenter, ProjectController projectController, LibraryPlaces libraryPlaces, Promises promises) {
        this.view = view;
        this.newFileUploader = newFileUploader;
        this.newResourcePresenter = newResourcePresenter;
        this.projectController = projectController;
        this.libraryPlaces = libraryPlaces;
        this.promises = promises;
    }

    @PostConstruct
    public void initialize() {
        this.view.init(this);
        this.projectController.canUpdateProject(this.libraryPlaces.getActiveWorkspace()).then(userCanUpdateProject -> {
            this.enableButtons((boolean)userCanUpdateProject);
            this.newFileUploader.acceptContext((Callback)new Callback<Boolean, Void>(){

                public void onFailure(Void reason) {
                    EmptyAssetsScreen.this.view.enableImportButton(false);
                }

                public void onSuccess(Boolean result) {
                    EmptyAssetsScreen.this.view.enableImportButton(result != false && userCanUpdateProject != false);
                }
            });
            return this.promises.resolve();
        });
    }

    private void enableButtons(boolean enable) {
        this.view.enableImportButton(enable);
        this.view.enableAddAssetButton(enable);
    }

    public void importAsset() {
        this.projectController.canUpdateProject(this.libraryPlaces.getActiveWorkspace()).then(userCanUpdateProject -> {
            if (userCanUpdateProject.booleanValue()) {
                this.newFileUploader.getCommand(this.newResourcePresenter).execute();
            }
            return this.promises.resolve();
        });
    }

    public void addAsset() {
        this.projectController.canUpdateProject(this.libraryPlaces.getActiveWorkspace()).then(userCanUpdateProject -> {
            if (userCanUpdateProject.booleanValue()) {
                this.libraryPlaces.goToAddAsset();
            }
            return this.promises.resolve();
        });
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElemental<EmptyAssetsScreen> {
        public void enableImportButton(boolean var1);

        public void enableAddAssetButton(boolean var1);
    }
}

