/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.importrepository;

import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.examples.exception.EmptyRemoteRepositoryException;
import org.kie.workbench.common.screens.examples.model.Credentials;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.examples.service.ProjectImportService;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.events.NotificationEvent;

public class ImportRepositoryPopUpPresenter {
    private View view;
    private Caller<ProjectImportService> importService;
    private LibraryPlaces libraryPlaces;
    private Caller<LibraryService> libraryService;
    private WorkspaceProjectContext projectContext;
    private Event<NotificationEvent> notificationEvent;
    private TranslationService ts;

    @Inject
    public ImportRepositoryPopUpPresenter(View view, LibraryPlaces libraryPlaces, Caller<ProjectImportService> importService, Caller<LibraryService> libraryService, WorkspaceProjectContext projectContext, Event<NotificationEvent> notificationEvent, TranslationService ts) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.importService = importService;
        this.libraryService = libraryService;
        this.projectContext = projectContext;
        this.notificationEvent = notificationEvent;
        this.ts = ts;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show() {
        this.view.show();
    }

    public void importRepository() {
        String repositoryUrl = this.view.getRepositoryURL();
        if (this.isEmpty(repositoryUrl)) {
            this.view.showError(this.view.getEmptyRepositoryURLValidationMessage());
            return;
        }
        String fixedRepositoryUrl = repositoryUrl.trim();
        this.view.showBusyIndicator(this.view.getLoadingMessage());
        ((ProjectImportService)this.importService.call(projects -> {
            this.view.hideBusyIndicator();
            if (projects.isEmpty()) {
                this.view.showError(this.view.getNoProjectsToImportMessage());
            } else {
                this.view.hide();
                this.libraryPlaces.goToExternalImportPresenter((Set<ImportProject>)projects);
            }
        }, (message, throwable) -> {
            if (throwable instanceof EmptyRemoteRepositoryException) {
                String repositoryAlias = ((EmptyRemoteRepositoryException)throwable).getRepositoryAlias();
                this.createProjectFromEmptyRemoteRepository(fixedRepositoryUrl, repositoryAlias);
            } else {
                this.view.hideBusyIndicator();
                this.view.showError(this.view.getNoProjectsToImportMessage());
            }
            return false;
        })).getProjects(this.libraryPlaces.getActiveSpace(), new ExampleRepository(fixedRepositoryUrl, new Credentials(this.view.getUserName(), this.view.getPassword())));
    }

    private void createProjectFromEmptyRemoteRepository(String repositoryUrl, String repositoryAlias) {
        ((LibraryService)this.libraryService.call(project -> {
            this.view.hideBusyIndicator();
            this.view.hide();
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("AddProjectSuccess"), NotificationEvent.NotificationType.SUCCESS));
            this.libraryPlaces.goToProject((WorkspaceProject)project);
        }, (message, throwable) -> {
            this.view.hideBusyIndicator();
            this.view.showError(this.view.getNoProjectsToImportMessage());
            return false;
        })).createProject(this.activeOrganizationalUnit(), repositoryUrl, repositoryAlias);
    }

    private OrganizationalUnit activeOrganizationalUnit() {
        return (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot create new project without an active organizational unit."));
    }

    public void cancel() {
        this.view.hide();
    }

    public View getView() {
        return this.view;
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static interface View
    extends UberElement<ImportRepositoryPopUpPresenter>,
    HasBusyIndicator {
        public String getRepositoryURL();

        public String getUserName();

        public String getPassword();

        public void show();

        public void hide();

        public void showError(String var1);

        public String getLoadingMessage();

        public String getNoProjectsToImportMessage();

        public String getEmptyRepositoryURLValidationMessage();
    }
}

