/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab;

import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListPresenter;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.events.NotificationEvent;

public class ContributorsListItemPresenter {
    private View view;
    private LibraryPlaces libraryPlaces;
    private Event<NotificationEvent> notificationEvent;
    Promises promises;
    private Contributor persistedContributor;
    private ContributorsListPresenter parentPresenter;
    private ContributorsListService contributorsListService;

    @Inject
    public ContributorsListItemPresenter(View view, LibraryPlaces libraryPlaces, Event<NotificationEvent> notificationEvent, Promises promises) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.notificationEvent = notificationEvent;
        this.promises = promises;
    }

    public void setupNew(ContributorsListPresenter parentPresenter, ContributorsListService contributorsListService) {
        this.parentPresenter = parentPresenter;
        this.contributorsListService = contributorsListService;
        this.view.init(this);
        this.view.setupAddMode();
    }

    public void setup(Contributor contributor, ContributorsListPresenter parentPresenter, ContributorsListService contributorsListService) {
        this.persistedContributor = contributor;
        this.parentPresenter = parentPresenter;
        this.contributorsListService = contributorsListService;
        this.view.init(this);
        this.view.setupViewMode(contributor);
    }

    public void edit() {
        this.parentPresenter.itemIsBeingEdited();
        this.view.editMode();
    }

    public void save() {
        Contributor contributor = new Contributor(this.view.getName(), this.view.getRole());
        this.contributorsListService.getContributors(currentContributors -> this.isValid(contributor, (List<Contributor>)currentContributors).then(isValid -> {
            if (isValid.booleanValue()) {
                ArrayList<Contributor> updatedContributors = new ArrayList<Contributor>();
                if (this.persistedContributor == null) {
                    updatedContributors.addAll((Collection<Contributor>)currentContributors);
                } else {
                    updatedContributors.addAll(currentContributors.stream().filter(c -> !c.equals((Object)this.persistedContributor)).collect(Collectors.toList()));
                }
                updatedContributors.add(contributor);
                this.view.showBusyIndicator(this.view.getSavingMessage());
                this.contributorsListService.saveContributors(updatedContributors, () -> {
                    this.persistedContributor = contributor;
                    this.view.setupViewMode(contributor);
                    this.parentPresenter.itemIsNotBeingEdited();
                    this.view.hideBusyIndicator();
                    this.notificationEvent.fire((Object)new NotificationEvent(this.view.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
                    this.parentPresenter.refresh();
                }, (ErrorCallback<Message>)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view));
            }
            return this.promises.resolve();
        }));
    }

    private Promise<Boolean> isValid(Contributor contributor, List<Contributor> currentContributors) {
        return this.contributorsListService.canEditContributors(currentContributors, contributor.getType()).then(canEditContributors -> {
            boolean userChanged;
            boolean validUsername;
            boolean emptyName;
            boolean bl = emptyName = contributor.getUsername() == null || contributor.getUsername().isEmpty();
            if (emptyName) {
                this.notificationEvent.fire((Object)new NotificationEvent(this.view.getEmptyNameMessage(), NotificationEvent.NotificationType.ERROR));
                return this.promises.resolve((Object)false);
            }
            boolean bl2 = validUsername = !this.contributorsListService.requireValidUsername() || this.parentPresenter.getValidUsernames().contains(contributor.getUsername());
            if (!validUsername) {
                this.notificationEvent.fire((Object)new NotificationEvent(this.view.getTranslation(this.contributorsListService.getInvalidNameMessageConstant()), NotificationEvent.NotificationType.ERROR));
                return this.promises.resolve((Object)false);
            }
            boolean newContributor = this.persistedContributor == null;
            boolean wasOwner = !newContributor && ContributorType.OWNER.equals((Object)this.persistedContributor.getType());
            boolean isOwner = ContributorType.OWNER.equals((Object)contributor.getType());
            if (!newContributor && wasOwner && !isOwner && this.isLastOwner(this.persistedContributor, currentContributors)) {
                this.notificationEvent.fire((Object)new NotificationEvent(this.view.getSingleOwnerIsMandatoryMessage(), NotificationEvent.NotificationType.ERROR));
                return this.promises.resolve((Object)false);
            }
            boolean userIsAlreadyAContributor = currentContributors.stream().anyMatch(c -> c.getUsername().equals(contributor.getUsername()));
            boolean bl3 = userChanged = !newContributor && !this.persistedContributor.getUsername().equals(contributor.getUsername());
            if (newContributor && userIsAlreadyAContributor || !newContributor && userChanged && userIsAlreadyAContributor) {
                this.notificationEvent.fire((Object)new NotificationEvent(this.view.getDuplicatedContributorMessage(), NotificationEvent.NotificationType.ERROR));
                return this.promises.resolve((Object)false);
            }
            if (!canEditContributors.booleanValue()) {
                this.notificationEvent.fire((Object)new NotificationEvent(this.view.getContributorTypeNotAllowedMessage(), NotificationEvent.NotificationType.ERROR));
                return this.promises.resolve((Object)false);
            }
            return this.promises.resolve((Object)true);
        });
    }

    public void remove() {
        this.canRemoveContributor().then(canRemoveContributor -> {
            if (canRemoveContributor.booleanValue()) {
                this.contributorsListService.getContributors(contributors -> {
                    if (this.isLastOwner(this.persistedContributor, (List<Contributor>)contributors)) {
                        this.notificationEvent.fire((Object)new NotificationEvent(this.view.getSingleOwnerIsMandatoryMessage(), NotificationEvent.NotificationType.ERROR));
                    } else {
                        contributors.remove(this.persistedContributor);
                        this.view.showBusyIndicator(this.view.getSavingMessage());
                        this.contributorsListService.saveContributors((List<Contributor>)contributors, () -> {
                            this.view.hideBusyIndicator();
                            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getRemoveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
                            this.view.removeContributor();
                            this.parentPresenter.refresh();
                        }, (ErrorCallback<Message>)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view));
                    }
                });
            }
            return this.promises.resolve();
        });
    }

    private boolean isLastOwner(Contributor contributor, List<Contributor> contributors) {
        return contributors.stream().noneMatch(c -> !c.getUsername().equals(contributor.getUsername()) && ContributorType.OWNER.equals((Object)c.getType()));
    }

    public void cancel() {
        if (this.persistedContributor != null) {
            this.view.setupViewMode(this.persistedContributor);
        } else {
            this.view.removeContributor();
        }
        this.parentPresenter.itemIsNotBeingEdited();
    }

    public void showActions() {
        this.view.showActions();
    }

    public void hideActions() {
        this.view.hideActions();
    }

    public Contributor getContributor() {
        return this.persistedContributor;
    }

    public List<String> getUserNames() {
        return this.parentPresenter.getValidUsernames();
    }

    public Promise<Boolean> canRemoveContributor() {
        return this.canEditContributors();
    }

    public Promise<Boolean> canEditContributors() {
        if (this.persistedContributor == null) {
            return this.promises.resolve((Object)false);
        }
        return this.parentPresenter.canEditContributors(this.persistedContributor.getType());
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElemental<ContributorsListItemPresenter>,
    HasBusyIndicator {
        public void setupAddMode();

        public void setupViewMode(Contributor var1);

        public void removeContributor();

        public void showActions();

        public void hideActions();

        public void viewMode();

        public void editMode();

        public String getName();

        public ContributorType getRole();

        public String getSavingMessage();

        public String getSaveSuccessMessage();

        public String getEmptyNameMessage();

        public String getInvalidRoleMessage();

        public String getRemoveSuccessMessage();

        public String getSpaceOwnerChangedMessage();

        public String getSingleOwnerIsMandatoryMessage();

        public String getDuplicatedContributorMessage();

        public String getContributorTypeNotAllowedMessage();

        public String getTranslation(String var1);
    }
}

