/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import javax.inject.Inject;
import org.guvnor.structure.contributors.ContributorType;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListPresenter;

@Templated
public class ContributorsListView
implements ContributorsListPresenter.View,
IsElement {
    private ContributorsListPresenter presenter;
    @Inject
    private TranslationService ts;
    @Inject
    @DataField(value="contributors-list")
    Div contributorsList;
    @Inject
    @DataField(value="filter-text")
    Input filterText;
    @Inject
    @DataField(value="add-contributor")
    Button addContributor;

    public void init(ContributorsListPresenter presenter) {
        this.presenter = presenter;
        this.filterText.setAttribute("placeholder", this.ts.getTranslation("Search"));
        presenter.canEditContributors(ContributorType.CONTRIBUTOR).then(canEditContributors -> {
            this.addContributor.setHidden(canEditContributors == false);
            return presenter.promises.resolve();
        });
    }

    @Override
    public void clearContributors() {
        this.contributorsList.setTextContent("");
    }

    @Override
    public void addNewContributor(HTMLElement newContributorView) {
        this.contributorsList.insertBefore((Node)newContributorView, this.contributorsList.getFirstChild());
    }

    @Override
    public void addContributor(HTMLElement contributor) {
        this.contributorsList.appendChild((Node)contributor);
    }

    @Override
    public void clearFilterText() {
        this.filterText.setValue("");
    }

    @Override
    public void showAddContributor() {
        this.presenter.canEditContributors(ContributorType.CONTRIBUTOR).then(canEditContributors -> {
            this.addContributor.setHidden(canEditContributors == false);
            return this.presenter.promises.resolve();
        });
    }

    @Override
    public void hideAddContributor() {
        this.addContributor.setHidden(true);
    }

    @EventHandler(value={"filter-text"})
    public void filterTextChange(KeyUpEvent event) {
        this.presenter.filterContributors(this.filterText.getValue());
    }

    @EventHandler(value={"add-contributor"})
    public void addContributor(ClickEvent event) {
        this.presenter.addContributor();
    }
}

