/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab;

import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.contributors.SpaceContributorsUpdatedEvent;
import org.guvnor.structure.events.AfterEditOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.screens.library.api.LibraryService;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListService;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsSecurityUtils;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.promise.Promises;
import org.uberfire.rpc.SessionInfo;

public class SpaceContributorsListServiceImpl
implements ContributorsListService {
    private LibraryPlaces libraryPlaces;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private Event<AfterEditOrganizationalUnitEvent> afterEditOrganizationalUnitEvent;
    private Caller<LibraryService> libraryService;
    private SessionInfo sessionInfo;
    private OrganizationalUnitController organizationalUnitController;
    private ContributorsSecurityUtils contributorsSecurityUtils;
    private Promises promises;
    private Consumer<Collection<Contributor>> contributorsConsumerForExternalChange;

    @Inject
    public SpaceContributorsListServiceImpl(LibraryPlaces libraryPlaces, Caller<OrganizationalUnitService> organizationalUnitService, Event<AfterEditOrganizationalUnitEvent> afterEditOrganizationalUnitEvent, Caller<LibraryService> libraryService, SessionInfo sessionInfo, OrganizationalUnitController organizationalUnitController, ContributorsSecurityUtils contributorsSecurityUtils, Promises promises) {
        this.libraryPlaces = libraryPlaces;
        this.organizationalUnitService = organizationalUnitService;
        this.afterEditOrganizationalUnitEvent = afterEditOrganizationalUnitEvent;
        this.libraryService = libraryService;
        this.sessionInfo = sessionInfo;
        this.organizationalUnitController = organizationalUnitController;
        this.contributorsSecurityUtils = contributorsSecurityUtils;
        this.promises = promises;
        this.contributorsConsumerForExternalChange = null;
    }

    @Override
    public void getContributors(Consumer<List<Contributor>> contributorsConsumer) {
        ((OrganizationalUnitService)this.organizationalUnitService.call(organizationalUnit -> contributorsConsumer.accept(new ArrayList(organizationalUnit.getContributors())))).getOrganizationalUnit(this.libraryPlaces.getActiveSpace().getName());
    }

    @Override
    public void saveContributors(List<Contributor> contributors, Runnable successCallback, ErrorCallback<Message> errorCallback) {
        ((OrganizationalUnitService)this.organizationalUnitService.call(organizationalUnit -> ((OrganizationalUnitService)this.organizationalUnitService.call(newOrganizationalUnit -> {
            successCallback.run();
            this.afterEditOrganizationalUnitEvent.fire((Object)new AfterEditOrganizationalUnitEvent(organizationalUnit, newOrganizationalUnit));
        }, errorCallback)).updateOrganizationalUnit(organizationalUnit.getName(), organizationalUnit.getDefaultGroupId(), (Collection)contributors))).getOrganizationalUnit(this.libraryPlaces.getActiveSpace().getName());
    }

    @Override
    public Promise<Boolean> canEditContributors(List<Contributor> contributors, ContributorType type) {
        if (this.organizationalUnitController.canUpdateOrgUnit(this.libraryPlaces.getActiveSpace())) {
            return this.promises.resolve((Object)true);
        }
        Optional<Contributor> contributor = contributors.stream().filter(c -> c.getUsername().equals(this.sessionInfo.getIdentity().getIdentifier())).findFirst();
        if (contributor.isPresent()) {
            ContributorType userContributorType = contributor.get().getType();
            return this.promises.resolve((Object)this.contributorsSecurityUtils.canUserEditContributorOfType(userContributorType, type));
        }
        return this.promises.resolve((Object)false);
    }

    @Override
    public void getValidUsernames(Consumer<List<String>> validUsernamesConsumer) {
        ((LibraryService)this.libraryService.call(validUsernamesConsumer::accept)).getAllUsers();
    }

    @Override
    public void onExternalChange(Consumer<Collection<Contributor>> contributorsConsumer) {
        this.contributorsConsumerForExternalChange = contributorsConsumer;
    }

    @Override
    public boolean requireValidUsername() {
        return false;
    }

    @Override
    public String getInvalidNameMessageConstant() {
        return "";
    }

    public void onSpaceContributorsUpdatedEvent(@Observes SpaceContributorsUpdatedEvent spaceContributorsUpdatedEvent) {
        if (this.contributorsConsumerForExternalChange != null && spaceContributorsUpdatedEvent.getOrganizationalUnit().getName().equals(this.libraryPlaces.getActiveSpace().getName())) {
            this.contributorsConsumerForExternalChange.accept(spaceContributorsUpdatedEvent.getOrganizationalUnit().getContributors());
        }
    }
}

