/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.settings;

import elemental2.dom.HTMLElement;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.api.settings.SpaceScreenModel;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.settings.annotation.SpaceSettings;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChangeType;
import org.kie.workbench.common.screens.library.client.settings.sections.SettingsSections;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class SettingsScreenPresenter
implements HasBusyIndicator {
    private final View view;
    private final TranslationService ts;
    private final OrganizationalUnitController organizationalUnitController;
    private final WorkspaceProjectContext projectContext;
    private final BusyIndicatorView busyIndicatorView;
    private final SectionManager<SpaceScreenModel> sectionManager;
    private final SettingsSections settingsSections;
    private final Promises promises;
    private final Event<NotificationEvent> notificationEvent;

    @Inject
    public SettingsScreenPresenter(View view, TranslationService ts, OrganizationalUnitController organizationalUnitController, WorkspaceProjectContext projectContext, BusyIndicatorView busyIndicatorView, SectionManager<SpaceScreenModel> sectionManager, @SpaceSettings SettingsSections settingsSections, Promises promises, Event<NotificationEvent> notificationEvent) {
        this.view = view;
        this.ts = ts;
        this.organizationalUnitController = organizationalUnitController;
        this.projectContext = projectContext;
        this.busyIndicatorView = busyIndicatorView;
        this.sectionManager = sectionManager;
        this.settingsSections = settingsSections;
        this.promises = promises;
        this.notificationEvent = notificationEvent;
    }

    @PostConstruct
    public void postConstruct() {
        this.sectionManager.init(this.settingsSections.getList(), this.view.getMenuItemsContainer(), this.view.getContentContainer());
    }

    public Promise<Void> setupUsingCurrentSection() {
        this.view.init(this);
        this.showBusyIndicator(this.ts.getTranslation("Loading"));
        this.view.enableActions(this.canUpdate());
        return this.setupSections(new SpaceScreenModel()).then(o -> {
            this.hideBusyIndicator();
            if (this.sectionManager.manages(this.sectionManager.getCurrentSection())) {
                return this.sectionManager.goToCurrentSection();
            }
            return this.sectionManager.goToFirstAvailable();
        }).catch_(o -> this.promises.catchOrExecute(o, e -> {
            this.hideBusyIndicator();
            return this.promises.reject(e);
        }, i -> {
            this.notificationEvent.fire((Object)new NotificationEvent(this.ts.getTranslation("SettingsLoadError"), NotificationEvent.NotificationType.ERROR));
            this.hideBusyIndicator();
            return this.promises.resolve();
        }));
    }

    public View getView() {
        return this.view;
    }

    private OrganizationalUnit getOrganizationalUnit() {
        return (OrganizationalUnit)this.projectContext.getActiveOrganizationalUnit().orElseThrow(() -> new IllegalStateException("Cannot get library info without an active organizational unit."));
    }

    private boolean canUpdate() {
        return this.organizationalUnitController.canUpdateOrgUnit(this.getOrganizationalUnit());
    }

    public void showBusyIndicator(String message) {
        this.busyIndicatorView.showBusyIndicator(message);
    }

    public void hideBusyIndicator() {
        this.busyIndicatorView.hideBusyIndicator();
    }

    public void onSettingsSectionChanged(@Observes SettingsSectionChange<SpaceScreenModel> settingsSectionChange) {
        if (this.sectionManager.manages(settingsSectionChange.getSection())) {
            if (settingsSectionChange.getType() == SettingsSectionChangeType.CHANGE) {
                this.sectionManager.updateDirtyIndicator(settingsSectionChange.getSection());
            } else if (settingsSectionChange.getType() == SettingsSectionChangeType.RESET) {
                this.setupSection(new SpaceScreenModel(), settingsSectionChange.getSection());
            }
        }
    }

    public void save() {
        if (this.canUpdate()) {
            this.sectionManager.validateAll().then(i -> {
                this.save("");
                return this.promises.resolve();
            }).catch_(o -> this.promises.catchOrExecute(o, e -> {
                this.hideBusyIndicator();
                return this.promises.reject(e);
            }, section -> {
                this.hideBusyIndicator();
                return this.sectionManager.goTo((Section<SpaceScreenModel>)section);
            }));
        }
    }

    public void reset() {
        this.setupUsingCurrentSection();
    }

    private void save(String comment) {
        this.promises.reduceLazilyChaining(this.getSavingSteps(comment), this::executeSavingStep).catch_(o -> this.promises.catchOrExecute(o, arg_0 -> ((Promises)this.promises).reject(arg_0), this.sectionManager::goTo));
    }

    private List<SavingStep> getSavingSteps(String comment) {
        Stream<SavingStep> saveSectionsSteps = this.sectionManager.getSections().stream().map(section -> chain -> section.save(comment, chain));
        Stream<SavingStep> commonSavingSteps = Stream.of(chain -> this.saveSpaceScreenModel(), chain -> this.sectionManager.resetAllDirtyIndicators(), chain -> this.displaySuccessMessage());
        return Stream.concat(saveSectionsSteps, commonSavingSteps).collect(Collectors.toList());
    }

    private Promise<Void> executeSavingStep(Supplier<Promise<Void>> chain, SavingStep savingStep) {
        return savingStep.execute(chain);
    }

    private Promise<Void> displaySuccessMessage() {
        this.hideBusyIndicator();
        this.notificationEvent.fire((Object)new NotificationEvent(this.getSaveSuccessMessage(), NotificationEvent.NotificationType.SUCCESS));
        return this.promises.resolve();
    }

    Promise<Object> setupSections(SpaceScreenModel model) {
        ArrayList<Section<SpaceScreenModel>> sections = new ArrayList<Section<SpaceScreenModel>>(this.sectionManager.getSections());
        return this.promises.all(sections, section -> this.setupSection(model, (Section<SpaceScreenModel>)section)).then(i -> {
            if (this.sectionManager.isEmpty()) {
                return this.promises.reject((Object)"No sections available");
            }
            return this.promises.resolve();
        });
    }

    private Promise<Void> saveSpaceScreenModel() {
        this.hideBusyIndicator();
        return this.promises.resolve();
    }

    Promise<Object> setupSection(SpaceScreenModel model, Section<SpaceScreenModel> section) {
        return section.setup(model).then(i -> {
            this.sectionManager.resetDirtyIndicator(section);
            return this.promises.resolve();
        }).catch_(e -> {
            this.sectionManager.remove(section);
            this.notificationEvent.fire((Object)new NotificationEvent(this.getSectionSetupErrorMessage(section), NotificationEvent.NotificationType.WARNING));
            return this.promises.resolve();
        });
    }

    private String getSectionSetupErrorMessage(Section<SpaceScreenModel> section) {
        return this.ts.format("SettingsSectionSetupError", new Object[]{section.getView().getTitle()});
    }

    private String getSaveSuccessMessage() {
        return this.ts.format("SettingsSaveSuccess", new Object[0]);
    }

    public static interface View
    extends UberElement<SettingsScreenPresenter> {
        public void enableActions(boolean var1);

        public HTMLElement getMenuItemsContainer();

        public HTMLElement getContentContainer();
    }

    @FunctionalInterface
    private static interface SavingStep {
        public Promise<Void> execute(Supplier<Promise<Void>> var1);
    }
}

