/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.branch;

import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLOptionElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.Node;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.project.branch.AddBranchPopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Templated
public class AddBranchPopUpView
implements AddBranchPopUpPresenter.View,
IsElement {
    private AddBranchPopUpPresenter presenter;
    @Inject
    private TranslationService ts;
    @Inject
    private ManagedInstance<BranchOptionView> options;
    private BaseModal modal;
    @Inject
    @DataField(value="body")
    HTMLDivElement body;
    @Inject
    @DataField(value="error")
    HTMLDivElement error;
    @Inject
    @Named(value="span")
    @DataField(value="error-message")
    HTMLElement errorMessage;
    @Inject
    @DataField(value="name")
    HTMLInputElement name;
    @Inject
    @DataField(value="branch-from")
    HTMLSelectElement branchFrom;
    private Button addButton;

    public void init(AddBranchPopUpPresenter presenter) {
        this.presenter = presenter;
        this.modalSetup();
    }

    @Override
    public void setBranches(List<String> branches) {
        this.branchFrom.innerHTML = "";
        branches.forEach(branch -> {
            BranchOptionView option = (BranchOptionView)this.options.get();
            option.setup((String)branch);
            this.branchFrom.appendChild((Node)option.getElement());
        });
    }

    @Override
    public String getName() {
        return this.name.value;
    }

    @Override
    public String getBranchFrom() {
        return this.branchFrom.value;
    }

    @Override
    public void setBranchFrom(String branchFrom) {
        this.branchFrom.value = branchFrom;
    }

    @Override
    public void show() {
        this.errorSetup();
        this.modal.show();
    }

    @Override
    public void showError(String errorMessage) {
        this.errorMessage.innerHTML = errorMessage;
        this.error.hidden = false;
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public String getSavingMessage() {
        return this.ts.format("Saving", new Object[0]);
    }

    @Override
    public String getAddBranchSuccessMessage() {
        return this.ts.format("AddBranchSuccess", new Object[0]);
    }

    @Override
    public String getDuplicatedBranchMessage() {
        return this.ts.format("DuplicatedBranchValidation", new Object[0]);
    }

    @Override
    public String getEmptyNameMessage() {
        return this.ts.format("EmptyFieldValidation", new Object[]{this.ts.getTranslation("Name")});
    }

    @Override
    public String getInvalidNameMessage() {
        return this.ts.format("InvalidBranchName", new Object[0]);
    }

    @Override
    public void setAddButtonEnabled(boolean enabled) {
        if (this.addButton != null) {
            this.addButton.setEnabled(enabled);
        }
    }

    private void modalSetup() {
        this.modal = new CommonModalBuilder().addHeader(this.ts.format("AddBranch", new Object[0])).addBody((HTMLElement)this.body).addFooter(this.footer()).build();
    }

    private ModalFooter footer() {
        GenericModalFooter footer = new GenericModalFooter();
        footer.add((Widget)this.cancelButton());
        footer.add((Widget)this.addButton());
        return footer;
    }

    private Button addButton() {
        this.addButton = this.button(this.ts.format("Add", new Object[0]), () -> this.presenter.add(), ButtonType.PRIMARY);
        return this.addButton;
    }

    private Button cancelButton() {
        return this.button(this.ts.format("Cancel", new Object[0]), () -> this.presenter.cancel(), ButtonType.DEFAULT);
    }

    private void errorSetup() {
        this.error.hidden = true;
    }

    private Button button(String text, Command command, ButtonType type) {
        Button button = new Button(text, event -> command.execute());
        button.setType(type);
        return button;
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Templated(value="AddBranchPopUpView.html#branch")
    public static class BranchOptionView
    implements IsElement {
        @Inject
        @DataField(value="branch")
        HTMLOptionElement option;

        public void setup(String branchName) {
            this.option.value = branchName;
            this.option.innerHTML = branchName;
        }
    }
}

