/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatus;
import org.jboss.errai.ui.client.local.spi.TranslationService;

@ApplicationScoped
public class ChangeRequestUtils {
    public static final String CHANGE_REQUEST_ID_KEY = "CHANGE_REQUEST_ID";
    private static final String CREATED_DATE_FORMAT = "MMM d, yyyy";
    private final TranslationService ts;

    @Inject
    public ChangeRequestUtils(TranslationService ts) {
        this.ts = ts;
    }

    public String formatCreatedDate(Date date) {
        return DateTimeFormat.getFormat((String)CREATED_DATE_FORMAT).format(date);
    }

    public String formatStatus(ChangeRequestStatus status) {
        switch (status) {
            case ACCEPTED: {
                return this.ts.getTranslation("AcceptedStatus");
            }
            case REJECTED: {
                return this.ts.getTranslation("RejectedStatus");
            }
            case REVERTED: {
                return this.ts.getTranslation("RevertedStatus");
            }
            case REVERT_FAILED: {
                return this.ts.getTranslation("RevertFailedStatus");
            }
            case CLOSED: {
                return this.ts.getTranslation("ClosedStatus");
            }
        }
        return this.ts.getTranslation("OpenStatus");
    }

    public String formatFilesSummary(int changedFiles, int addedLines, int deletedLines) {
        if (changedFiles == 1) {
            if (addedLines == 0) {
                return this.formatFilesSummaryForOneFileZeroAdditions(deletedLines);
            }
            if (addedLines == 1) {
                return this.formatFilesSummaryForOneFileOneAddition(deletedLines);
            }
            return this.formatFilesSummaryForOneFileManyAdditions(addedLines, deletedLines);
        }
        if (addedLines == 0) {
            return this.formatFilesSummaryForManyFilesZeroAdditions(changedFiles, deletedLines);
        }
        if (addedLines == 1) {
            return this.formatFilesSummaryForManyFilesOneAddition(changedFiles, deletedLines);
        }
        return this.formatFilesSummaryForManyFilesManyAdditions(changedFiles, addedLines, deletedLines);
    }

    private String formatFilesSummaryForOneFileZeroAdditions(int deletedLines) {
        if (deletedLines == 0) {
            return this.ts.getTranslation("ChangeRequestFilesSummaryOneFile");
        }
        if (deletedLines == 1) {
            return this.ts.getTranslation("ChangeRequestFilesSummaryOneFileOneDeletion");
        }
        return this.ts.format("ChangeRequestFilesSummaryOneFileManyDeletions", new Object[]{deletedLines});
    }

    private String formatFilesSummaryForOneFileOneAddition(int deletedLines) {
        if (deletedLines == 0) {
            return this.ts.getTranslation("ChangeRequestFilesSummaryOneFileOneAddition");
        }
        if (deletedLines == 1) {
            return this.ts.getTranslation("ChangeRequestFilesSummaryOneFileOneAdditionOneDeletion");
        }
        return this.ts.format("ChangeRequestFilesSummaryOneFileOneAdditionManyDeletions", new Object[]{deletedLines});
    }

    private String formatFilesSummaryForOneFileManyAdditions(int addedLines, int deletedLines) {
        if (deletedLines == 0) {
            return this.ts.format("ChangeRequestFilesSummaryOneFileManyAdditions", new Object[]{addedLines});
        }
        if (deletedLines == 1) {
            return this.ts.format("ChangeRequestFilesSummaryOneFileManyAdditionsOneDeletion", new Object[]{addedLines});
        }
        return this.ts.format("ChangeRequestFilesSummaryOneFileManyAdditionsManyDeletions", new Object[]{addedLines, deletedLines});
    }

    private String formatFilesSummaryForManyFilesZeroAdditions(int changedFiles, int deletedLines) {
        if (deletedLines == 0) {
            return this.ts.format("ChangeRequestFilesSummaryManyFiles", new Object[]{changedFiles});
        }
        if (deletedLines == 1) {
            return this.ts.format("ChangeRequestFilesSummaryManyFilesOneDeletion", new Object[]{changedFiles});
        }
        return this.ts.format("ChangeRequestFilesSummaryManyFilesManyDeletions", new Object[]{changedFiles, deletedLines});
    }

    private String formatFilesSummaryForManyFilesOneAddition(int changedFiles, int deletedLines) {
        if (deletedLines == 0) {
            return this.ts.format("ChangeRequestFilesSummaryManyFilesOneAddition", new Object[]{changedFiles});
        }
        if (deletedLines == 1) {
            return this.ts.format("ChangeRequestFilesSummaryManyFilesOneAdditionOneDeletion", new Object[]{changedFiles});
        }
        return this.ts.format("ChangeRequestFilesSummaryManyFilesOneAdditionManyDeletions", new Object[]{changedFiles, deletedLines});
    }

    private String formatFilesSummaryForManyFilesManyAdditions(int changedFiles, int addedLines, int deletedLines) {
        if (deletedLines == 0) {
            return this.ts.format("ChangeRequestFilesSummaryManyFilesManyAdditions", new Object[]{changedFiles, addedLines});
        }
        if (deletedLines == 1) {
            return this.ts.format("ChangeRequestFilesSummaryManyFilesManyAdditionsOneDeletion", new Object[]{changedFiles, addedLines});
        }
        return this.ts.format("ChangeRequestFilesSummaryManyFilesManyAdditionsManyDeletions", new Object[]{changedFiles, addedLines, deletedLines});
    }
}

