/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.diff;

import com.google.gwt.user.client.Random;
import elemental2.dom.HTMLElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestDiff;
import org.guvnor.structure.repositories.changerequest.portable.ChangeType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.diff.DiffPrintState;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.ResourceTypeManagerCache;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.diff.DiffMode;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@Dependent
public class DiffItemPresenter {
    private final View view;
    private final ResourceTypeManagerCache resourceTypeManagerCache;
    private final PlaceManager placeManager;
    private final TranslationService ts;
    private DiffMode diffMode;
    private PlaceRequest placeRequestCustomLeft;
    private PlaceRequest placeRequestCustomRight;
    private ChangeRequestDiff diff;
    private boolean ready;
    private boolean open = false;
    private boolean canClose = false;

    @Inject
    public DiffItemPresenter(View view, ResourceTypeManagerCache resourceTypeManagerCache, PlaceManager placeManager, TranslationService ts) {
        this.view = view;
        this.resourceTypeManagerCache = resourceTypeManagerCache;
        this.placeManager = placeManager;
        this.ts = ts;
    }

    @PostConstruct
    public void postConstruct() {
        this.view.init(this);
    }

    @PreDestroy
    public void preDestroy() {
        if (this.ready && this.open) {
            this.closeContent();
        }
    }

    public View getView() {
        return this.view;
    }

    public void setup(ChangeRequestDiff changeRequestDiff, boolean warnConflict) {
        this.diff = changeRequestDiff;
        this.diffMode = this.resolveDiffMode(this.diff);
        String resolveDiffFilename = this.resolveDiffFilename(this.diff.getChangeType(), this.diff.getOldFilePath().getFileName(), this.diff.getNewFilePath().getFileName());
        this.prepareDiff(this.diff, resolveDiffFilename, warnConflict);
        this.view.expandCollapsibleContainer(this.open);
        if (this.open && !this.canClose) {
            this.view.removeCollapseLink();
        }
        this.ready = true;
    }

    public void draw() {
        if (this.ready) {
            if (this.open) {
                this.openContent();
            }
        } else {
            throw new IllegalStateException("Item not ready - setup first.");
        }
    }

    public void toggleCollapsibleContainerState() {
        this.open = !this.open;
        this.handleContent();
    }

    private void prepareDiff(ChangeRequestDiff diff, String filename, boolean warnConflict) {
        if (this.diffMode == DiffMode.VISUAL) {
            this.prepareVisualDiff(diff, filename, warnConflict);
        } else {
            this.prepareTextualDiff(diff, filename, warnConflict);
        }
    }

    private void handleContent() {
        if (this.ready) {
            if (this.open) {
                this.openContent();
                if (!this.canClose) {
                    this.view.removeCollapseLink();
                    this.view.expandCollapsibleContainer(true);
                }
            } else if (this.canClose) {
                this.closeContent();
            }
        }
    }

    private void closeContent() {
        if (this.diffMode == DiffMode.VISUAL) {
            this.closeVisualContent();
        } else {
            this.closeTextualContent();
        }
    }

    private void openContent() {
        if (this.diffMode == DiffMode.VISUAL) {
            this.drawVisualContent();
        } else {
            this.drawTextualContent();
        }
    }

    PlaceRequest createPlaceRequest(Path path) {
        return new PathPlaceRequest(path, this.createPathPlaceRequestParameters());
    }

    private void drawTextualContent() {
        DiffPrintState diffPrintState = this.resolvePrintState(this.diff);
        switch (diffPrintState) {
            case BINARY: {
                this.view.drawBinaryContent();
                break;
            }
            case UNMODIFIED: {
                this.view.drawUnmodifiedContent();
                break;
            }
            default: {
                boolean isUnified = this.diff.getChangeType() == ChangeType.ADD || this.diff.getChangeType() == ChangeType.DELETE;
                this.view.drawTextualContent(this.diff.getDiffText(), isUnified);
            }
        }
    }

    private void drawVisualContent() {
        if (this.diff.getChangeType() != ChangeType.ADD) {
            this.placeRequestCustomLeft = this.createPlaceRequest(this.diff.getOldFilePath());
            this.placeManager.goTo(this.placeRequestCustomLeft, this.view.getCustomLeftContainer());
        }
        if (this.diff.getChangeType() != ChangeType.DELETE) {
            this.placeRequestCustomRight = this.createPlaceRequest(this.diff.getNewFilePath());
            this.placeManager.goTo(this.placeRequestCustomRight, this.view.getCustomRightContainer());
        }
    }

    private void closeVisualContent() {
        if (this.placeRequestCustomLeft != null) {
            this.view.clearCustomLeftContainer();
            this.placeManager.closePlace(this.placeRequestCustomLeft);
        }
        if (this.placeRequestCustomRight != null) {
            this.view.clearCustomRightContainer();
            this.placeManager.closePlace(this.placeRequestCustomRight);
        }
    }

    private void closeTextualContent() {
        this.view.removeTextualContent();
    }

    private Map<String, String> createPathPlaceRequestParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("readOnly", "true");
        parameters.put("hash", this.generateRandomHash());
        return parameters;
    }

    private String generateRandomHash() {
        int leftLimit = 97;
        int rightLimit = 122;
        int targetStringLength = 32;
        StringBuilder buffer = new StringBuilder(targetStringLength);
        for (int i = 0; i < targetStringLength; ++i) {
            int randomLimitedInt = leftLimit + Random.nextInt() * (rightLimit - leftLimit + 1);
            buffer.append((char)randomLimitedInt);
        }
        return buffer.toString();
    }

    private void prepareTextualDiff(ChangeRequestDiff diff, String filename, boolean warnConflict) {
        this.view.setupTextualContent(filename, this.resolveChangeTypeText(diff.getChangeType()), warnConflict && diff.isConflict() != false);
    }

    private void prepareVisualDiff(ChangeRequestDiff diff, String filename, boolean warnConflict) {
        this.view.setupCustomContent(filename, this.resolveChangeTypeText(diff.getChangeType()), warnConflict && diff.isConflict() != false);
        if (diff.getChangeType() == ChangeType.ADD) {
            this.view.expandCustomRightContainer();
        } else if (diff.getChangeType() == ChangeType.DELETE) {
            this.view.expandCustomLeftContainer();
        }
    }

    private DiffMode resolveDiffMode(ChangeRequestDiff diff) {
        Path filePath = diff.getChangeType() == ChangeType.ADD ? diff.getNewFilePath() : diff.getOldFilePath();
        Optional<ResourceTypeDefinition> resourceTypeDefinition = this.resourceTypeManagerCache.getResourceTypeDefinitions().stream().filter(resource -> resource.accept(filePath)).findFirst();
        if (resourceTypeDefinition.isPresent()) {
            return resourceTypeDefinition.get().getDiffMode();
        }
        return DiffMode.TEXTUAL;
    }

    private String resolveDiffFilename(ChangeType changeType, String oldFilePath, String newFilePath) {
        if (changeType == ChangeType.ADD) {
            return newFilePath;
        }
        if (changeType == ChangeType.DELETE || changeType == ChangeType.MODIFY) {
            return oldFilePath;
        }
        return oldFilePath + " -> " + newFilePath;
    }

    private String resolveChangeTypeText(ChangeType changeType) {
        switch (changeType) {
            case ADD: {
                return this.ts.getTranslation("Added");
            }
            case DELETE: {
                return this.ts.getTranslation("Deleted");
            }
            case RENAME: {
                return this.ts.getTranslation("Renamed");
            }
            case COPY: {
                return this.ts.getTranslation("Copied");
            }
        }
        return this.ts.getTranslation("Updated");
    }

    private DiffPrintState resolvePrintState(ChangeRequestDiff changeRequestDiff) {
        if (changeRequestDiff.getAddedLinesCount() == 0 && changeRequestDiff.getDeletedLinesCount() == 0) {
            if (changeRequestDiff.getDiffText().contains("Binary files differ")) {
                return DiffPrintState.BINARY;
            }
            return DiffPrintState.UNMODIFIED;
        }
        return DiffPrintState.REGULAR;
    }

    public static interface View
    extends UberElemental<DiffItemPresenter> {
        public void setupTextualContent(String var1, String var2, boolean var3);

        public void drawTextualContent(String var1, boolean var2);

        public void setupCustomContent(String var1, String var2, boolean var3);

        public void expandCustomLeftContainer();

        public void expandCustomRightContainer();

        public HTMLElement getCustomLeftContainer();

        public HTMLElement getCustomRightContainer();

        public void clearCustomLeftContainer();

        public void clearCustomRightContainer();

        public void expandCollapsibleContainer(boolean var1);

        public void drawBinaryContent();

        public void drawUnmodifiedContent();

        public void removeTextualContent();

        public void removeCollapseLink();
    }
}

