/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.list;

import elemental2.dom.HTMLElement;
import java.util.function.IntConsumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.list.EmptyChangeRequestListPresenter;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.list.PopulatedChangeRequestListPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

@Dependent
public class ChangeRequestListPresenter {
    private final View view;
    private final LibraryPlaces libraryPlaces;
    private final EmptyChangeRequestListPresenter emptyChangeRequestsScreen;
    private final PopulatedChangeRequestListPresenter populatedChangeRequestsScreen;
    private final TranslationService ts;
    private final BusyIndicatorView busyIndicatorView;
    private final Caller<ChangeRequestService> changeRequestService;
    private WorkspaceProject workspaceProject;

    @Inject
    public ChangeRequestListPresenter(View view, LibraryPlaces libraryPlaces, EmptyChangeRequestListPresenter emptyChangeRequestsScreen, PopulatedChangeRequestListPresenter populatedChangeRequestsScreen, TranslationService ts, BusyIndicatorView busyIndicatorView, Caller<ChangeRequestService> changeRequestService) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.emptyChangeRequestsScreen = emptyChangeRequestsScreen;
        this.populatedChangeRequestsScreen = populatedChangeRequestsScreen;
        this.ts = ts;
        this.busyIndicatorView = busyIndicatorView;
        this.changeRequestService = changeRequestService;
    }

    @PostConstruct
    public void postConstruct() {
        this.workspaceProject = this.libraryPlaces.getActiveWorkspace();
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void setupList(IntConsumer openChangeRequestsCallback) {
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("Loading"));
        ((ChangeRequestService)this.changeRequestService.call(countSummary -> {
            openChangeRequestsCallback.accept(countSummary.getOpen());
            HTMLElement element = countSummary.getTotal() == 0 ? this.emptyChangeRequestsScreen.getView().getElement() : this.populatedChangeRequestsScreen.getView().getElement();
            this.ensureContentSet(element);
            this.busyIndicatorView.hideBusyIndicator();
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).countChangeRequests(this.workspaceProject.getSpace().getName(), this.workspaceProject.getRepository().getAlias());
    }

    private void ensureContentSet(HTMLElement element) {
        if (element.parentNode == null) {
            this.view.setContent(element);
        }
    }

    public static interface View
    extends UberElemental<ChangeRequestListPresenter> {
        public void setContent(HTMLElement var1);
    }
}

