/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.list;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestListUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatus;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatusUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.PaginatedChangeRequestList;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.api.RepositoryFileListUpdatedEvent;
import org.kie.workbench.common.screens.library.client.resources.images.LibraryImages;
import org.kie.workbench.common.screens.library.client.screens.EmptyState;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.list.listitem.ChangeRequestListItemView;
import org.kie.workbench.common.screens.library.client.util.DateUtils;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.ext.widgets.common.client.select.SelectOption;
import org.uberfire.ext.widgets.common.client.select.SelectOptionImpl;
import org.uberfire.mvp.Command;

@Dependent
public class PopulatedChangeRequestListPresenter {
    private static final int PAGE_SIZE = 10;
    private static final String FILTER_OPEN = "OPEN";
    private static final String FILTER_CLOSED = "CLOSED";
    private static final String FILTER_ALL = "ALL";
    private final View view;
    private final ProjectController projectController;
    private final LibraryPlaces libraryPlaces;
    private final Promises promises;
    private final EmptyState emptyState;
    private final TranslationService ts;
    private final ManagedInstance<ChangeRequestListItemView> changeRequestListItemViewInstances;
    private final Caller<ChangeRequestService> changeRequestService;
    private final BusyIndicatorView busyIndicatorView;
    private final DateUtils dateUtils;
    private WorkspaceProject workspaceProject;
    private int currentPage;
    private String searchFilter;
    private int totalPages;
    private String filterType;

    @Inject
    public PopulatedChangeRequestListPresenter(View view, ProjectController projectController, LibraryPlaces libraryPlaces, Promises promises, EmptyState emptyState, TranslationService ts, ManagedInstance<ChangeRequestListItemView> changeRequestItemViews, Caller<ChangeRequestService> changeRequestService, BusyIndicatorView busyIndicatorView, DateUtils dateUtils) {
        this.view = view;
        this.projectController = projectController;
        this.libraryPlaces = libraryPlaces;
        this.promises = promises;
        this.emptyState = emptyState;
        this.ts = ts;
        this.changeRequestListItemViewInstances = changeRequestItemViews;
        this.changeRequestService = changeRequestService;
        this.busyIndicatorView = busyIndicatorView;
        this.dateUtils = dateUtils;
    }

    @PostConstruct
    public void postConstruct() {
        this.workspaceProject = this.libraryPlaces.getActiveWorkspace();
        this.view.init(this);
        this.setupFilter();
        this.projectController.canSubmitChangeRequest(this.workspaceProject).then(userCanSubmitChangeRequest -> {
            this.view.enableSubmitChangeRequestButton((boolean)userCanSubmitChangeRequest);
            return this.promises.resolve();
        });
        this.refreshList();
    }

    public View getView() {
        return this.view;
    }

    public void onChangeRequestListUpdated(@Observes ChangeRequestListUpdatedEvent event) {
        if (event.getRepositoryId().equals(this.workspaceProject.getRepository().getIdentifier())) {
            this.refreshList();
        }
    }

    public void onChangeRequestUpdated(@Observes ChangeRequestUpdatedEvent event) {
        if (event.getRepositoryId().equals(this.workspaceProject.getRepository().getIdentifier())) {
            this.refreshList();
        }
    }

    public void onChangeRequestStatusUpdated(@Observes ChangeRequestStatusUpdatedEvent event) {
        if (event.getRepositoryId().equals(this.workspaceProject.getRepository().getIdentifier()) && (event.getOldStatus() == ChangeRequestStatus.OPEN || event.getNewStatus() == ChangeRequestStatus.OPEN)) {
            this.refreshList();
        }
    }

    public void onRepositoryFileListUpdated(@Observes RepositoryFileListUpdatedEvent event) {
        if (event.getRepositoryId().equals(this.workspaceProject.getRepository().getIdentifier())) {
            this.refreshList();
        }
    }

    public void nextPage() {
        if (this.currentPage + 1 <= this.totalPages) {
            ++this.currentPage;
            this.refreshList();
        }
    }

    public void prevPage() {
        if (this.currentPage - 1 >= 1) {
            --this.currentPage;
            this.refreshList();
        }
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage <= this.totalPages && currentPage > 0) {
            this.currentPage = currentPage;
            this.refreshList();
        } else {
            this.view.setCurrentPage(this.currentPage);
        }
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
        this.searchFilter = "";
        this.view.clearSearch();
        this.currentPage = 1;
        this.refreshList();
    }

    public void submitChangeRequest() {
        this.projectController.canSubmitChangeRequest(this.workspaceProject).then(userCanSubmitChangeRequest -> {
            if (Boolean.TRUE.equals(userCanSubmitChangeRequest)) {
                this.libraryPlaces.goToSubmitChangeRequestScreen();
            }
            return this.promises.resolve();
        });
    }

    public void search(String searchText) {
        this.searchFilter = searchText;
        this.currentPage = 1;
        this.refreshList();
    }

    public void showSearchHitNothing() {
        this.showEmptyState(this.ts.getTranslation("EmptySearch"), this.ts.getTranslation("NoChangeRequestsFound"));
    }

    private String formatCreatedTime(Date createdDate) {
        return this.ts.format("Submitted", new Object[0]) + " " + this.dateUtils.format(createdDate);
    }

    private String formatChangedFiles(int changedFilesCount) {
        if (changedFilesCount == 1) {
            return this.ts.getTranslation("ChangeRequestFilesSummaryOneFile");
        }
        return this.ts.format("ChangeRequestFilesSummaryManyFiles", new Object[]{changedFilesCount});
    }

    private void setupFilter() {
        List<SelectOption> filterTypes = this.createFilterTypes();
        this.view.setFilterTypes(filterTypes);
        this.filterType = filterTypes.get(0).getSelector();
        this.searchFilter = "";
        this.currentPage = 1;
        this.view.setFilterTextPlaceHolder(this.ts.getTranslation("SearchByIdOrSummary"));
    }

    private void showEmptyState(String title, String message) {
        this.emptyState.clear();
        this.emptyState.setMessage(title, message);
        this.view.showEmptyState(this.emptyState);
    }

    private void hideEmptyState() {
        this.emptyState.clear();
        this.view.hideEmptyState(this.emptyState);
    }

    private Command selectCommand(long changeRequestId) {
        return () -> this.libraryPlaces.goToChangeRequestReviewScreen(changeRequestId);
    }

    private void refreshList() {
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("Loading"));
        if (this.filterType.equals(FILTER_ALL)) {
            ((ChangeRequestService)this.changeRequestService.call(this.getChangeRequestsCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).getChangeRequests(this.workspaceProject.getSpace().getName(), this.workspaceProject.getRepository().getAlias(), Integer.valueOf(Math.max(0, this.currentPage - 1)), Integer.valueOf(10), this.searchFilter);
        } else {
            ((ChangeRequestService)this.changeRequestService.call(this.getChangeRequestsCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).getChangeRequests(this.workspaceProject.getSpace().getName(), this.workspaceProject.getRepository().getAlias(), Integer.valueOf(Math.max(0, this.currentPage - 1)), Integer.valueOf(10), this.getStatusByFilterType(), this.searchFilter);
        }
    }

    private RemoteCallback<PaginatedChangeRequestList> getChangeRequestsCallback() {
        return paginatedList -> {
            this.setupCounters(paginatedList.getTotal());
            this.view.clearList();
            if (paginatedList.getTotal() == 0) {
                this.showSearchHitNothing();
            } else {
                this.hideEmptyState();
                paginatedList.getChangeRequests().forEach(item -> {
                    ChangeRequestListItemView viewItem = (ChangeRequestListItemView)this.changeRequestListItemViewInstances.get();
                    viewItem.init(this.resolveChangeRequestStatusIcon(item.getStatus()), item.toString(), item.getAuthorId(), this.formatCreatedTime(item.getCreatedDate()), this.formatChangedFiles(item.getChangedFilesCount()), String.valueOf(item.getCommentsCount()), this.selectCommand(item.getId()));
                    this.view.addChangeRequestItem(viewItem);
                });
            }
            this.busyIndicatorView.hideBusyIndicator();
        };
    }

    private IsWidget resolveChangeRequestStatusIcon(ChangeRequestStatus status) {
        switch (status) {
            case OPEN: {
                return new Image(LibraryImages.INSTANCE.changeRequestOpenStatus().getSafeUri());
            }
            case ACCEPTED: 
            case REVERTED: 
            case REVERT_FAILED: {
                return new Image(LibraryImages.INSTANCE.changeRequestMergedStatus().getSafeUri());
            }
        }
        return new Image(LibraryImages.INSTANCE.changeRequestClosedStatus().getSafeUri());
    }

    private void setupCounters(int totalChangeRequests) {
        int offset = (this.currentPage - 1) * 10;
        int fromCount = totalChangeRequests > 0 ? offset + 1 : offset;
        int toCount = this.resolveCounter(totalChangeRequests, offset + 10);
        int totalCount = this.resolveCounter(totalChangeRequests, 0);
        String indicatorText = this.ts.format("ItemCountIndicatorText", new Object[]{fromCount, toCount, totalCount});
        this.view.setPageIndicator(indicatorText);
        this.totalPages = (int)Math.ceil((float)totalChangeRequests / 10.0f);
        String totalText = this.ts.format("OfN", new Object[]{Math.max(this.totalPages, 1)});
        this.view.setTotalPages(totalText);
        this.view.setCurrentPage(this.currentPage);
        this.checkPaginationButtons();
    }

    private List<ChangeRequestStatus> getStatusByFilterType() {
        ArrayList<ChangeRequestStatus> statusList = new ArrayList<ChangeRequestStatus>();
        if (this.filterType.equals(FILTER_CLOSED)) {
            statusList.add(ChangeRequestStatus.ACCEPTED);
            statusList.add(ChangeRequestStatus.REJECTED);
            statusList.add(ChangeRequestStatus.REVERT_FAILED);
            statusList.add(ChangeRequestStatus.REVERTED);
            statusList.add(ChangeRequestStatus.CLOSED);
        } else if (this.filterType.equals(FILTER_OPEN)) {
            statusList.add(ChangeRequestStatus.OPEN);
        } else {
            statusList.addAll(Arrays.asList(ChangeRequestStatus.values()));
        }
        return statusList;
    }

    private void checkPaginationButtons() {
        boolean isPreviousButtonEnabled = this.currentPage > 1;
        boolean isNextButtonEnabled = this.currentPage < this.totalPages;
        this.view.enablePreviousButton(isPreviousButtonEnabled);
        this.view.enableNextButton(isNextButtonEnabled);
    }

    private List<SelectOption> createFilterTypes() {
        return Arrays.asList(new SelectOptionImpl(FILTER_OPEN, this.ts.getTranslation("Open")), new SelectOptionImpl(FILTER_CLOSED, this.ts.getTranslation("Closed")), new SelectOptionImpl(FILTER_ALL, this.ts.getTranslation(FILTER_ALL)));
    }

    private int resolveCounter(int numberOfChangeRequests, int otherCounter) {
        if (numberOfChangeRequests < otherCounter || otherCounter == 0) {
            return numberOfChangeRequests;
        }
        return otherCounter;
    }

    public static interface View
    extends UberElemental<PopulatedChangeRequestListPresenter> {
        public void setCurrentPage(int var1);

        public void setPageIndicator(String var1);

        public void setTotalPages(String var1);

        public void clearList();

        public void enablePreviousButton(boolean var1);

        public void enableNextButton(boolean var1);

        public void setFilterTypes(List<SelectOption> var1);

        public void clearSearch();

        public void enableSubmitChangeRequestButton(boolean var1);

        public void showEmptyState(EmptyState var1);

        public void hideEmptyState(EmptyState var1);

        public void addChangeRequestItem(ChangeRequestListItemView var1);

        public void setFilterTextPlaceHolder(String var1);
    }
}

