/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.list;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.HTMLLabelElement;
import elemental2.dom.Node;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.EmptyState;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.list.PopulatedChangeRequestListPresenter;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.list.listitem.ChangeRequestListItemView;
import org.uberfire.ext.widgets.common.client.select.SelectComponent;
import org.uberfire.ext.widgets.common.client.select.SelectOption;

@Templated
public class PopulatedChangeRequestListView
implements IsElement,
PopulatedChangeRequestListPresenter.View {
    private static final String PLACE_HOLDER = "placeholder";
    @Inject
    @DataField(value="indexing-info")
    private HTMLDivElement indexingInfo;
    @Inject
    @DataField(value="change-requests-list")
    private HTMLDivElement changeRequestsList;
    @Inject
    @DataField(value="filter-type")
    private HTMLDivElement filterType;
    @Inject
    @DataField(value="filter-text")
    private HTMLInputElement filterText;
    @Inject
    @DataField(value="search")
    private HTMLButtonElement search;
    @Inject
    @DataField(value="page-indicator")
    private HTMLLabelElement pageIndicator;
    @Inject
    @DataField(value="total-pages")
    @Named(value="span")
    private HTMLElement totalPages;
    @Inject
    @DataField(value="current-page")
    private HTMLInputElement currentPage;
    @Inject
    @DataField(value="prev-page")
    private HTMLButtonElement prevPage;
    @Inject
    @DataField(value="next-page")
    private HTMLButtonElement nextPage;
    @Inject
    @DataField(value="submit-change-request")
    private HTMLButtonElement submitChangeRequest;
    @Inject
    private SelectComponent selectComponent;
    @Inject
    private Elemental2DomUtil domUtil;
    private PopulatedChangeRequestListPresenter presenter;

    public void init(PopulatedChangeRequestListPresenter presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"next-page"})
    public void nextPage(ClickEvent event) {
        this.presenter.nextPage();
    }

    @EventHandler(value={"prev-page"})
    public void prevPage(ClickEvent event) {
        this.presenter.prevPage();
    }

    @EventHandler(value={"search"})
    public void search(ClickEvent event) {
        this.doSearch();
    }

    @EventHandler(value={"filter-text"})
    public void search(KeyUpEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.doSearch();
        }
    }

    @EventHandler(value={"current-page"})
    public void currentPageTextChange(KeyUpEvent event) {
        String pageNumber = this.currentPage.value;
        if (pageNumber.matches("\\d+")) {
            this.presenter.setCurrentPage(Integer.parseInt(pageNumber));
        }
    }

    @EventHandler(value={"submit-change-request"})
    public void onSubmitChangeRequestClicked(ClickEvent event) {
        this.presenter.submitChangeRequest();
    }

    @Override
    public void addChangeRequestItem(ChangeRequestListItemView item) {
        this.changeRequestsList.appendChild((Node)item.getElement());
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.currentPage.value = String.valueOf(currentPage);
    }

    @Override
    public void setPageIndicator(String pageIndicatorText) {
        this.pageIndicator.textContent = pageIndicatorText;
    }

    @Override
    public void setTotalPages(String totalText) {
        this.totalPages.textContent = totalText;
    }

    @Override
    public void clearList() {
        this.domUtil.removeAllElementChildren((Node)this.changeRequestsList);
    }

    @Override
    public void enablePreviousButton(boolean isEnabled) {
        this.prevPage.disabled = !isEnabled;
    }

    @Override
    public void enableNextButton(boolean isEnabled) {
        this.nextPage.disabled = !isEnabled;
    }

    @Override
    public void setFilterTypes(List<SelectOption> categories) {
        this.selectComponent.setup(categories, selectOption -> this.presenter.setFilterType(selectOption.getSelector()));
        this.filterType.appendChild((Node)this.selectComponent.getView().getElement());
    }

    @Override
    public void clearSearch() {
        this.search.value = "";
    }

    @Override
    public void enableSubmitChangeRequestButton(boolean isEnabled) {
        this.submitChangeRequest.disabled = !isEnabled;
    }

    @Override
    public void showEmptyState(EmptyState emptyState) {
        this.indexingInfo.className = "blank-slate-pf";
        this.indexingInfo.innerHTML = emptyState.getElement().getOuterHTML();
    }

    @Override
    public void hideEmptyState(EmptyState emptyState) {
        emptyState.clear();
        this.indexingInfo.className = "";
        this.indexingInfo.innerHTML = "";
    }

    @Override
    public void setFilterTextPlaceHolder(String placeHolder) {
        this.filterText.setAttribute(PLACE_HOLDER, placeHolder);
    }

    private void doSearch() {
        this.presenter.search(this.filterText.value);
    }
}

