/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.close;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.client.screens.project.close.CloseUnsavedProjectAssetsPopUpListItemPresenter;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.util.URIUtil;

public class CloseUnsavedProjectAssetsPopUpPresenter {
    private final View view;
    private final ManagedInstance<CloseUnsavedProjectAssetsPopUpListItemPresenter> closeUnsavedProjectAssetsPopUpListItemPresenters;
    private final TranslationService translationService;
    Command proceedCallback;
    Command cancelCallback;

    @Inject
    public CloseUnsavedProjectAssetsPopUpPresenter(View view, ManagedInstance<CloseUnsavedProjectAssetsPopUpListItemPresenter> closeUnsavedProjectAssetsPopUpListItemPresenters, TranslationService translationService) {
        this.view = view;
        this.closeUnsavedProjectAssetsPopUpListItemPresenters = closeUnsavedProjectAssetsPopUpListItemPresenters;
        this.translationService = translationService;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(WorkspaceProject project, List<PlaceRequest> uncloseablePlaces, Command proceedCallback, Command cancelCallback) {
        this.proceedCallback = proceedCallback;
        this.cancelCallback = cancelCallback;
        this.view.clearPlaces();
        uncloseablePlaces.forEach(place -> {
            CloseUnsavedProjectAssetsPopUpListItemPresenter placeItem = (CloseUnsavedProjectAssetsPopUpListItemPresenter)this.closeUnsavedProjectAssetsPopUpListItemPresenters.get();
            placeItem.setup(this.getLabel(project, (PlaceRequest)place));
            this.view.addPlace(placeItem.getView());
        });
        this.view.show(project.getName());
    }

    public void proceed() {
        this.view.hide();
        this.proceedCallback.execute();
    }

    public void cancel() {
        this.view.hide();
        this.cancelCallback.execute();
    }

    private String getLabel(WorkspaceProject project, PlaceRequest place) {
        if (place instanceof PathPlaceRequest) {
            return this.getAssetPath(project, ((PathPlaceRequest)place).getPath().toURI());
        }
        if (place.getIdentifier().equals("ProjectScreen")) {
            return this.translationService.format("ProjectScreenSettings", new Object[]{project.getName()});
        }
        return place.getFullIdentifier();
    }

    private String getAssetPath(WorkspaceProject project, String fullPath) {
        String projectRootPath = project.getRootPath().toURI();
        String relativeAssetPath = fullPath.substring(projectRootPath.length());
        String decodedRelativeAssetPath = URIUtil.decode((String)relativeAssetPath);
        return decodedRelativeAssetPath;
    }

    public static interface View
    extends UberElemental<CloseUnsavedProjectAssetsPopUpPresenter> {
        public void addPlace(CloseUnsavedProjectAssetsPopUpListItemPresenter.View var1);

        public void show(String var1);

        public void hide();

        public void clearPlaces();
    }
}

