/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.generalsettings;

import elemental2.dom.HTMLInputElement;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.projecteditor.model.GitUrl;
import org.kie.workbench.common.widgets.client.widget.KieSelectOption;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.util.Clipboard;
import org.uberfire.workbench.events.NotificationEvent;

public class GitUrlsPresenter {
    private static final String DEFAULT_SELECTED_PROTOCOL = "ssh";
    private final View view;
    private final Event<NotificationEvent> notificationEventEvent;
    private final TranslationService translationService;
    private final Clipboard clipboard;
    Map<String, GitUrl> gitUrlsByProtocol;
    String selectedProtocol;

    @Inject
    public GitUrlsPresenter(View view, Event<NotificationEvent> notificationEventEvent, TranslationService translationService, Clipboard clipboard) {
        this.view = view;
        this.notificationEventEvent = notificationEventEvent;
        this.translationService = translationService;
        this.clipboard = clipboard;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setup(List<GitUrl> gitUrls) {
        this.gitUrlsByProtocol = gitUrls.stream().collect(Collectors.toMap(GitUrl::getProtocol, Function.identity()));
        this.selectedProtocol = this.gitUrlsByProtocol.containsKey(DEFAULT_SELECTED_PROTOCOL) ? DEFAULT_SELECTED_PROTOCOL : gitUrls.get(0).getProtocol();
        this.view.setupProtocols(gitUrls.stream().map(GitUrl::getProtocol).map(p -> new KieSelectOption(p, p)).collect(Collectors.toList()), this.selectedProtocol, this::setSelectedProtocol);
        this.update();
    }

    public void setSelectedProtocol(String selectedProtocol) {
        this.selectedProtocol = selectedProtocol;
        this.update();
    }

    void update() {
        this.view.setUrl(this.gitUrlsByProtocol.get(this.selectedProtocol).getUrl());
    }

    public void copyToClipboard(HTMLInputElement element) {
        if (this.clipboard.copy(element)) {
            this.notificationEventEvent.fire((Object)new NotificationEvent(this.translationService.format("GitUrlSuccessfullyCopiedToClipboard", new Object[0]), NotificationEvent.NotificationType.SUCCESS));
        } else {
            this.notificationEventEvent.fire((Object)new NotificationEvent(this.translationService.format("GitUrlFailedToBeCopiedToClipboard", new Object[0]), NotificationEvent.NotificationType.WARNING));
        }
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElemental<GitUrlsPresenter>,
    IsElement {
        public void setUrl(String var1);

        public void setupProtocols(List<KieSelectOption> var1, String var2, Consumer<String> var3);
    }
}

