/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.util.sections;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.settings.util.sections.MenuItem;

@Templated
public class MenuItemView<T>
implements MenuItem.View<T> {
    @Inject
    @Named(value="sup")
    private HTMLElement dirtyIndicator;
    @Inject
    @DataField(value="section-menu-item-link")
    private HTMLAnchorElement sectionMenuItemLink;
    private MenuItem presenter;

    public void init(MenuItem<T> presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"section-menu-item-link"})
    public void onSectionMenuItemLinkClicked(ClickEvent ignore) {
        this.presenter.showSection();
    }

    @Override
    public void setLabel(String label) {
        this.sectionMenuItemLink.textContent = label;
    }

    @Override
    public void markAsDirty(boolean dirty) {
        if (dirty && this.sectionMenuItemLink.childElementCount == 0.0) {
            this.sectionMenuItemLink.appendChild((Node)this.newDirtyIndicator());
        } else if (!dirty && this.sectionMenuItemLink.childElementCount > 0.0) {
            this.sectionMenuItemLink.removeChild((Node)this.sectionMenuItemLink.lastElementChild);
        }
    }

    @Override
    public void setActive() {
        this.getElement().classList.add(new String[]{"active"});
    }

    private HTMLElement newDirtyIndicator() {
        HTMLElement dirtyIndicator = (HTMLElement)this.dirtyIndicator.cloneNode(false);
        dirtyIndicator.textContent = " *";
        return dirtyIndicator;
    }
}

