/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.util.sections;

import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.kie.workbench.common.screens.library.client.settings.util.sections.MenuItemsListPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.uberfire.client.promise.Promises;

@Dependent
public class SectionManager<T> {
    private final MenuItemsListPresenter<T> menuItemsListPresenter;
    private final Promises promises;
    private final Elemental2DomUtil elemental2DomUtil;
    List<Section<T>> sections;
    private HTMLElement menuItemsContainer;
    private HTMLElement contentContainer;
    Map<Section<T>, Integer> originalHashCodes;
    private Section<T> currentSection;

    @Inject
    public SectionManager(MenuItemsListPresenter<T> menuItemsListPresenter, Promises promises, Elemental2DomUtil elemental2DomUtil) {
        this.menuItemsListPresenter = menuItemsListPresenter;
        this.promises = promises;
        this.elemental2DomUtil = elemental2DomUtil;
    }

    public void init(List<Section<T>> sections, HTMLElement menuItemsContainer, HTMLElement contentContainer) {
        this.sections = new ArrayList<Section<T>>(sections);
        this.currentSection = sections.get(0);
        this.menuItemsContainer = menuItemsContainer;
        this.contentContainer = contentContainer;
        this.originalHashCodes = new HashMap<Section<T>, Integer>();
        this.currentSection.setActive();
        this.setupMenuItems();
    }

    private void setupMenuItems() {
        List menuItems = this.sections.stream().peek(section -> section.getMenuItem().setup(section, this)).map(Section::getMenuItem).collect(Collectors.toList());
        this.menuItemsListPresenter.setupWithPresenters((Element)this.menuItemsContainer, menuItems, (section, menuItem) -> menuItem.setup(section, this));
    }

    public Promise<Void> goTo(Section<T> section) {
        this.currentSection = section;
        this.elemental2DomUtil.removeAllElementChildren((Node)this.contentContainer);
        this.contentContainer.appendChild((Node)section.getView().getElement());
        return this.promises.resolve();
    }

    public Promise<Void> goToFirstAvailable() {
        return this.goTo(this.sections.get(0));
    }

    public Promise<Void> goToCurrentSection() {
        return this.goTo(this.currentSection);
    }

    public Promise<Object> validateAll() {
        return this.promises.reduceLazily(this.sections, Section::validate);
    }

    public void remove(Section<T> section) {
        this.sections.remove(section);
    }

    public Promise<Void> resetAllDirtyIndicators() {
        this.sections.forEach(this::resetDirtyIndicator);
        return this.promises.resolve();
    }

    public void resetDirtyIndicator(Section<T> section) {
        this.originalHashCodes.put(section, section.currentHashCode());
        this.updateDirtyIndicator(section);
    }

    public void updateDirtyIndicator(Section<T> section) {
        section.setDirty(this.isDirty(section));
    }

    private boolean isDirty(Section<T> section) {
        return this.originalHashCodes.containsKey(section) && !this.originalHashCodes.get(section).equals(section.currentHashCode());
    }

    public boolean manages(Section<T> section) {
        return this.sections.contains(section);
    }

    public boolean isEmpty() {
        return this.sections.isEmpty();
    }

    public List<Section<T>> getSections() {
        return this.sections;
    }

    public Section<T> getCurrentSection() {
        return this.currentSection;
    }

    public boolean hasDirtySections() {
        return this.sections.stream().anyMatch(this::isDirty);
    }
}

