/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.util.select;

import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.widget.KieSelectElement;
import org.kie.workbench.common.widgets.client.widget.KieSelectOption;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class KieEnumSelectElement<T extends Enum<T>>
implements IsElement {
    private final View view;
    private final KieSelectElement kieSelectElement;
    private final TranslationService translationService;
    Class<T> componentType;

    @Inject
    public KieEnumSelectElement(View view, KieSelectElement kieSelectElement, TranslationService translationService) {
        this.view = view;
        this.kieSelectElement = kieSelectElement;
        this.translationService = translationService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setup(T[] values, T initialValue, Consumer<T> onChange) {
        this.componentType = values.getClass().getComponentType();
        this.view.setupKieSelectElement(this.buildOptions((Enum[])values), ((Enum)initialValue).name(), name -> onChange.accept(this.toEnum((String)name)));
    }

    List<KieSelectOption> buildOptions(T[] values) {
        return Arrays.stream(values).map(this::newOption).collect(Collectors.toList());
    }

    KieSelectOption newOption(T e) {
        return new KieSelectOption(this.getLabel(e), ((Enum)e).name());
    }

    String getLabel(T e) {
        return this.translationService.format(((Enum)e).name(), new Object[0]);
    }

    public T getValue() {
        return this.toEnum(this.kieSelectElement.getValue());
    }

    T toEnum(String value) {
        return Enum.valueOf(this.componentType, value);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public static interface View
    extends UberElemental<KieEnumSelectElement> {
        public void setupKieSelectElement(List<KieSelectOption> var1, String var2, Consumer<String> var3);
    }
}

