/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.api.ProjectAssetListUpdated;
import org.kie.workbench.common.screens.library.api.Routed;
import org.kie.workbench.common.screens.library.client.events.WorkbenchProjectMetricsEvent;
import org.kie.workbench.common.screens.library.client.util.ProjectMetricsFactory;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.lifecycle.OnClose;

public class ProjectMetricsScreen {
    View view;
    TranslationService translationService;
    ProjectMetricsFactory metricsFactory;
    DisplayerCoordinator displayerCoordinator;
    WorkspaceProject workspaceProject;
    Displayer commitsOverTimeDisplayer;
    Displayer commitsPerAuthorDisplayer;
    Displayer commitsByYearDisplayer;
    Displayer commitsByQuarterDisplayer;
    Displayer commitsByDayOfWeekDisplayer;
    Displayer topAuthorSelectorDisplayer;
    Displayer dateSelectorDisplayer;
    Displayer allCommitsDisplayer;

    @Inject
    public ProjectMetricsScreen(View view, TranslationService translationService, ProjectMetricsFactory metricsFactory, DisplayerCoordinator displayerCoordinator) {
        this.view = view;
        this.translationService = translationService;
        this.metricsFactory = metricsFactory;
        this.displayerCoordinator = displayerCoordinator;
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    public void onStartup(@Observes WorkbenchProjectMetricsEvent event) {
        this.onStartup(event.getProject());
    }

    public void onStartup(WorkspaceProject workspaceProject) {
        this.view.init(this);
        this.workspaceProject = workspaceProject;
        this.buildMetrics(workspaceProject);
    }

    private void buildMetrics(WorkspaceProject projectInfo) {
        this.commitsOverTimeDisplayer = this.metricsFactory.lookupCommitsOverTimeDisplayer(projectInfo);
        this.commitsPerAuthorDisplayer = this.metricsFactory.lookupCommitsPerAuthorDisplayer(projectInfo);
        this.commitsByYearDisplayer = this.metricsFactory.lookupCommitsByYearDisplayer(projectInfo);
        this.commitsByQuarterDisplayer = this.metricsFactory.lookupCommitsByQuarterDisplayer(projectInfo);
        this.commitsByDayOfWeekDisplayer = this.metricsFactory.lookupCommitsByDayOfWeekDisplayer(projectInfo);
        this.allCommitsDisplayer = this.metricsFactory.lookupAllCommitsDisplayer(projectInfo);
        this.topAuthorSelectorDisplayer = this.metricsFactory.lookupTopContributorSelectorDisplayer(projectInfo);
        this.dateSelectorDisplayer = this.metricsFactory.lookupDateSelectorDisplayer(projectInfo);
        this.view.clear();
        this.view.setCommitsPerAuthorDisplayer(this.commitsPerAuthorDisplayer);
        this.view.setCommitsOverTimeDisplayer(this.commitsOverTimeDisplayer);
        this.view.setCommitsByYearDisplayer(this.commitsByYearDisplayer);
        this.view.setCommitsByQuarterDisplayer(this.commitsByQuarterDisplayer);
        this.view.setCommitsByDayOfWeekDisplayer(this.commitsByDayOfWeekDisplayer);
        this.view.setAllCommitsDisplayer(this.allCommitsDisplayer);
        this.view.setTopContribSelectorDisplayer(this.topAuthorSelectorDisplayer);
        this.view.setDateSelectorDisplayer(this.dateSelectorDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsPerAuthorDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsOverTimeDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsByYearDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsByQuarterDisplayer);
        this.displayerCoordinator.addDisplayer(this.commitsByDayOfWeekDisplayer);
        this.displayerCoordinator.addDisplayer(this.allCommitsDisplayer);
        this.displayerCoordinator.addDisplayer(this.topAuthorSelectorDisplayer);
        this.displayerCoordinator.addDisplayer(this.dateSelectorDisplayer);
        this.displayerCoordinator.drawAll();
    }

    @OnClose
    public void onClose() {
        this.displayerCoordinator.closeAll();
        this.view.clear();
    }

    public void onProjectAssetListUpdated(@Observes @Routed ProjectAssetListUpdated event) {
        if (this.workspaceProject != null && event.getProject().getRepository().getIdentifier().equals(this.workspaceProject.getRepository().getIdentifier())) {
            this.onStartup(event.getProject());
        }
    }

    public Displayer getCommitsOverTimeDisplayer() {
        return this.commitsOverTimeDisplayer;
    }

    public Displayer getCommitsPerAuthorDisplayer() {
        return this.commitsPerAuthorDisplayer;
    }

    public Displayer getCommitsByYearDisplayer() {
        return this.commitsByYearDisplayer;
    }

    public Displayer getCommitsByQuarterDisplayer() {
        return this.commitsByQuarterDisplayer;
    }

    public Displayer getCommitsByDayOfWeekDisplayer() {
        return this.commitsByDayOfWeekDisplayer;
    }

    public Displayer getTopAuthorSelectorDisplayer() {
        return this.topAuthorSelectorDisplayer;
    }

    public Displayer getDateSelectorDisplayer() {
        return this.dateSelectorDisplayer;
    }

    public Displayer getAllCommitsDisplayer() {
        return this.allCommitsDisplayer;
    }

    public static interface View
    extends UberElement<ProjectMetricsScreen> {
        public void setHeaderTitle(String var1);

        public void setTopContribSelectorDisplayer(Displayer var1);

        public void setDateSelectorDisplayer(Displayer var1);

        public void setCommitsOverTimeDisplayer(Displayer var1);

        public void setCommitsPerAuthorDisplayer(Displayer var1);

        public void setCommitsByYearDisplayer(Displayer var1);

        public void setCommitsByQuarterDisplayer(Displayer var1);

        public void setCommitsByDayOfWeekDisplayer(Displayer var1);

        public void setAllCommitsDisplayer(Displayer var1);

        public void clear();
    }
}

