/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.list;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;

@Dependent
public class EmptyChangeRequestListPresenter {
    private final View view;
    private final ProjectController projectController;
    private final LibraryPlaces libraryPlaces;
    private final Promises promises;
    private WorkspaceProject workspaceProject;

    @Inject
    public EmptyChangeRequestListPresenter(View view, ProjectController projectController, LibraryPlaces libraryPlaces, Promises promises) {
        this.view = view;
        this.projectController = projectController;
        this.libraryPlaces = libraryPlaces;
        this.promises = promises;
    }

    @PostConstruct
    public void postConstruct() {
        this.workspaceProject = this.libraryPlaces.getActiveWorkspace();
        this.view.init(this);
        this.projectController.canSubmitChangeRequest(this.workspaceProject).then(userCanSubmitChangeRequest -> {
            this.view.enableSubmitChangeRequestButton((boolean)userCanSubmitChangeRequest);
            return this.promises.resolve();
        });
    }

    public View getView() {
        return this.view;
    }

    public void goToSubmitChangeRequest() {
        this.projectController.canSubmitChangeRequest(this.workspaceProject).then(userCanSubmitChangeRequest -> {
            if (Boolean.TRUE.equals(userCanSubmitChangeRequest)) {
                this.libraryPlaces.goToSubmitChangeRequestScreen();
            }
            return this.promises.resolve();
        });
    }

    public static interface View
    extends UberElemental<EmptyChangeRequestListPresenter> {
        public void enableSubmitChangeRequestButton(boolean var1);
    }
}

