/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.importrepository;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.importrepository.ImportPresenter;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Templated
public class ImportProjectsView
implements ImportPresenter.View,
IsElement {
    private ImportPresenter presenter;
    @Inject
    private TranslationService ts;
    @Inject
    @DataField(value="title")
    Div title;
    @Inject
    @DataField(value="project-list")
    Div projectList;
    @Inject
    @DataField(value="filter-text")
    Input filterText;
    @Inject
    @DataField(value="cancel")
    Button cancel;
    @Inject
    @DataField(value="ok")
    Button ok;

    public void init(ImportPresenter presenter) {
        this.presenter = presenter;
        this.filterText.setAttribute("placeholder", this.ts.getTranslation("Search"));
    }

    @Override
    public void setTitle(String title) {
        this.title.setTextContent(title);
    }

    @Override
    public void clearProjects() {
        this.projectList.setTextContent("");
    }

    @Override
    public void addProject(HTMLElement project) {
        this.projectList.appendChild((Node)project);
    }

    @Override
    public String getNumberOfAssetsMessage(int numberOfAssets) {
        return this.ts.format("NumberOfAssets", new Object[]{numberOfAssets});
    }

    @Override
    public String getNoProjectsToImportMessage() {
        return this.ts.format("NoProjectsToImport", new Object[0]);
    }

    @Override
    public String getImportingMessage() {
        return this.ts.format("Importing", new Object[0]);
    }

    @Override
    public String getLoadingMessage() {
        return this.ts.format("Loading", new Object[0]);
    }

    @Override
    public String getNoProjectsSelectedMessage() {
        return this.ts.format("NoProjectsSelected", new Object[0]);
    }

    @Override
    public String getImportProjectsSuccessMessage() {
        return this.ts.format("ImportProjectsSuccess", new Object[0]);
    }

    @Override
    public String getTitle() {
        return this.title.getTextContent();
    }

    @EventHandler(value={"filter-text"})
    public void filterTextChange(KeyUpEvent event) {
        this.presenter.filterProjects(this.filterText.getValue());
    }

    @EventHandler(value={"cancel"})
    public void cancel(ClickEvent event) {
        this.presenter.cancel();
    }

    @EventHandler(value={"ok"})
    public void ok(ClickEvent event) {
        this.presenter.ok();
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

