/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.Node;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.library.client.screens.project.ProjectScreen;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Templated
public class ProjectView
implements ProjectScreen.View,
IsElement {
    public static final String ACTIVE = "active";
    private static final String HIDDEN_CLASS = "hidden";
    private ProjectScreen presenter;
    @Inject
    private TranslationService translationService;
    @Inject
    private Elemental2DomUtil domUtil;
    @Inject
    @DataField(value="title")
    private HTMLDivElement title;
    @Inject
    @DataField(value="assets-link")
    private HTMLAnchorElement assetsTabLink;
    @Inject
    @DataField(value="assets-tab")
    private HTMLLIElement assetsTabItem;
    @Inject
    @DataField(value="change-requests-link")
    private HTMLAnchorElement changeRequestsTabLink;
    @Inject
    @DataField(value="change-requests-tab")
    private HTMLLIElement changeRequestsTabItem;
    @Inject
    @DataField(value="contributors-link")
    private HTMLAnchorElement contributorsTabLink;
    @Inject
    @DataField(value="contributors-tab")
    private HTMLLIElement contributorsTabItem;
    @Inject
    @DataField(value="metrics-link")
    private HTMLAnchorElement metricsTabLink;
    @Inject
    @DataField(value="metrics-tab")
    private HTMLLIElement metricsTabItem;
    @Inject
    @DataField(value="settings-link")
    private HTMLAnchorElement settingsTabLink;
    @Inject
    @DataField(value="settings-tab")
    private HTMLLIElement settingsTabItem;
    @Inject
    @DataField(value="main-container")
    private HTMLDivElement mainContainer;
    @Inject
    @Named(value="span")
    @DataField(value="assets-count")
    private HTMLElement assetsCount;
    @Inject
    @Named(value="span")
    @DataField(value="change-requests-count")
    private HTMLElement changeRequestsCount;
    @Inject
    @Named(value="span")
    @DataField(value="actions-dropdown")
    private HTMLElement actionsDropdown;
    @Inject
    @Named(value="span")
    @DataField(value="contributors-count")
    private HTMLElement contributorsCount;
    @Inject
    @DataField(value="delete-project")
    private HTMLAnchorElement deleteProject;
    @Inject
    @DataField(value="delete-branch")
    private HTMLAnchorElement deleteBranch;
    @Inject
    @DataField(value="submit-change-request")
    private HTMLAnchorElement submitChangeRequest;
    @Inject
    @DataField(value="import-asset-action")
    private HTMLAnchorElement importAsset;
    @Inject
    @DataField(value="add-asset-action")
    private HTMLAnchorElement addAsset;
    @Inject
    @DataField(value="rename")
    private HTMLAnchorElement rename;
    @Inject
    @DataField(value="duplicate")
    private HTMLAnchorElement duplicate;
    @Inject
    @DataField(value="reimport")
    private HTMLAnchorElement reimport;
    @Inject
    @DataField(value="main-actions")
    private HTMLDivElement mainActions;

    @Override
    public void setAssetsCount(int count) {
        this.assetsCount.textContent = String.valueOf(count);
    }

    @Override
    public void setChangeRequestsCount(int count) {
        this.changeRequestsCount.textContent = String.valueOf(count);
    }

    @Override
    public void setContributorsCount(int count) {
        this.contributorsCount.textContent = String.valueOf(count);
    }

    @Override
    public void setContent(HTMLElement content) {
        this.domUtil.removeAllElementChildren((Node)this.mainContainer);
        this.mainContainer.appendChild((Node)content);
    }

    @Override
    public void setTitle(String projectName) {
        this.title.textContent = projectName;
    }

    @Override
    public void setAddAssetVisible(boolean visible) {
        this.addAsset.hidden = !visible;
    }

    @Override
    public void setImportAssetVisible(boolean visible) {
        this.importAsset.hidden = !visible;
    }

    @Override
    public void setDuplicateVisible(boolean visible) {
        this.duplicate.hidden = !visible;
    }

    @Override
    public void setReimportVisible(boolean visible) {
        this.reimport.hidden = !visible;
    }

    @Override
    public void setDeleteProjectVisible(boolean visible) {
        this.deleteProject.hidden = !visible;
    }

    @Override
    public void setDeleteBranchVisible(boolean visible) {
        this.deleteBranch.hidden = !visible;
    }

    @Override
    public void setSubmitChangeRequestVisible(boolean visible) {
        this.submitChangeRequest.hidden = !visible;
    }

    @Override
    public void viewMetricsTab(boolean visible) {
        this.metricsTabItem.hidden = !visible;
    }

    @Override
    public void viewChangeRequestTab(boolean visible) {
        this.changeRequestsTabItem.hidden = !visible;
    }

    @Override
    public void viewProjectToolbar(boolean visible) {
        if (!visible) {
            this.actionsDropdown.classList.add(new String[]{HIDDEN_CLASS});
        }
    }

    @Override
    public void setActionsVisible(boolean visible) {
        this.actionsDropdown.hidden = !visible;
    }

    @Override
    public String getLoadingMessage() {
        return this.translationService.getTranslation("Loading");
    }

    @Override
    public String getItemSuccessfullyDuplicatedMessage() {
        return this.translationService.getTranslation("ItemSuccessfullyDuplicated");
    }

    @Override
    public String getReimportSuccessfulMessage() {
        return this.translationService.getTranslation("ReimportSuccessful");
    }

    @Override
    public void addMainAction(HTMLElement element) {
        this.domUtil.removeAllElementChildren((Node)this.mainActions);
        this.mainActions.appendChild((Node)element);
    }

    public void init(ProjectScreen presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"assets-link"})
    public void clickAssetsTab(ClickEvent clickEvent) {
        this.deactivateAllTabs();
        this.activate(this.assetsTabItem);
        this.presenter.showAssets();
    }

    @EventHandler(value={"change-requests-link"})
    public void clickChangeRequestsTab(ClickEvent clickEvent) {
        this.deactivateAllTabs();
        this.activate(this.changeRequestsTabItem);
        this.presenter.showChangeRequests();
    }

    @EventHandler(value={"contributors-link"})
    public void clickContributorsTab(ClickEvent clickEvent) {
        this.deactivateAllTabs();
        this.activate(this.contributorsTabItem);
        this.presenter.showContributors();
    }

    @EventHandler(value={"metrics-link"})
    public void clickMetricsTab(ClickEvent clickEvent) {
        this.deactivateAllTabs();
        this.activate(this.metricsTabItem);
        this.presenter.showMetrics();
    }

    @EventHandler(value={"settings-link"})
    public void clickSettingsTab(ClickEvent clickEvent) {
        this.deactivateAllTabs();
        this.activate(this.settingsTabItem);
        this.presenter.showSettings();
    }

    @EventHandler(value={"delete-project"})
    public void deleteProject(ClickEvent event) {
        this.presenter.deleteProject();
    }

    @EventHandler(value={"delete-branch"})
    public void deleteBranch(ClickEvent event) {
        this.presenter.deleteBranch();
    }

    @EventHandler(value={"submit-change-request"})
    public void submitChangeRequest(ClickEvent event) {
        this.presenter.submitChangeRequest();
    }

    @EventHandler(value={"import-asset-action"})
    public void importAsset(ClickEvent event) {
        this.presenter.importAsset();
    }

    @EventHandler(value={"rename"})
    public void rename(ClickEvent event) {
        this.presenter.rename();
    }

    @EventHandler(value={"add-asset-action"})
    public void addAsset(ClickEvent event) {
        this.presenter.addAsset();
    }

    @EventHandler(value={"duplicate"})
    public void duplicate(ClickEvent event) {
        this.presenter.duplicate();
    }

    @EventHandler(value={"reimport"})
    public void reimport(ClickEvent event) {
        this.presenter.reimport();
    }

    private void activate(HTMLLIElement element) {
        element.classList.add(new String[]{ACTIVE});
    }

    private void deactivate(HTMLLIElement element) {
        element.classList.remove(new String[]{ACTIVE});
    }

    private void deactivateAllTabs() {
        this.deactivate(this.assetsTabItem);
        this.deactivate(this.changeRequestsTabItem);
        this.deactivate(this.contributorsTabItem);
        this.deactivate(this.metricsTabItem);
        this.deactivate(this.settingsTabItem);
    }

    @Override
    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    @Override
    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

