/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.review.comment;

import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.screens.library.client.util.DateUtils;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.rpc.SessionInfo;

@Dependent
public class CommentItemPresenter {
    private final View view;
    private final DateUtils dateUtils;
    private final Caller<ChangeRequestService> changeRequestService;
    private final SessionInfo sessionInfo;
    private final LibraryPlaces libraryPlaces;
    private Long changeRequestId;
    private Long commentId;
    private String authorId;

    @Inject
    public CommentItemPresenter(View view, DateUtils dateUtils, Caller<ChangeRequestService> changeRequestService, SessionInfo sessionInfo, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.dateUtils = dateUtils;
        this.changeRequestService = changeRequestService;
        this.sessionInfo = sessionInfo;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void postConstruct() {
        this.view.init(this);
    }

    public void setup(Long changeRequestId, Long commentId, String authorId, Date date, String text) {
        this.changeRequestId = changeRequestId;
        this.commentId = commentId;
        this.authorId = authorId;
        this.view.setAuthor(authorId);
        this.view.setDate(this.dateUtils.format(date));
        this.view.setText(text);
        this.view.showActions(this.isUserAuthor());
    }

    public View getView() {
        return this.view;
    }

    public void delete() {
        if (this.isUserAuthor()) {
            WorkspaceProject workspaceProject = this.libraryPlaces.getActiveWorkspace();
            ((ChangeRequestService)this.changeRequestService.call()).deleteComment(workspaceProject.getSpace().getName(), workspaceProject.getRepository().getAlias(), this.changeRequestId, this.commentId);
        }
    }

    private boolean isUserAuthor() {
        return this.authorId.equals(this.sessionInfo.getIdentity().getIdentifier());
    }

    public static interface View
    extends UberElemental<CommentItemPresenter> {
        public void delete();

        public void setAuthor(String var1);

        public void setDate(String var1);

        public void setText(String var1);

        public void showActions(boolean var1);
    }
}

