/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.review.tab.changedfiles;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequest;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestDiff;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatus;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.ChangeRequestUtils;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.diff.DiffItemPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class ChangedFilesScreenPresenter {
    private final View view;
    private final ManagedInstance<DiffItemPresenter> diffItemPresenterInstances;
    private final ChangeRequestUtils changeRequestUtils;
    private final Caller<ChangeRequestService> changeRequestService;
    private final LibraryPlaces libraryPlaces;
    private WorkspaceProject workspaceProject;

    @Inject
    public ChangedFilesScreenPresenter(View view, ManagedInstance<DiffItemPresenter> diffItemPresenterInstances, ChangeRequestUtils changeRequestUtils, Caller<ChangeRequestService> changeRequestService, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.diffItemPresenterInstances = diffItemPresenterInstances;
        this.changeRequestUtils = changeRequestUtils;
        this.changeRequestService = changeRequestService;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void postConstruct() {
        this.workspaceProject = this.libraryPlaces.getActiveWorkspace();
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void reset() {
        this.view.resetAll();
        this.destroyDiffItems();
    }

    public void setup(ChangeRequest changeRequest, Consumer<Boolean> finishLoadingCallback, IntConsumer setChangedFilesCountCallback) {
        ((ChangeRequestService)this.changeRequestService.call(diffList -> {
            setChangedFilesCountCallback.accept(diffList.size());
            if (!diffList.isEmpty()) {
                boolean warnConflict = changeRequest.getStatus() == ChangeRequestStatus.OPEN;
                this.setupDiffList((List<ChangeRequestDiff>)diffList, warnConflict);
                this.view.showDiffList(true);
            } else {
                this.destroyDiffItems();
                this.view.clearDiffList();
            }
            this.setupFilesSummary((List<ChangeRequestDiff>)diffList);
            finishLoadingCallback.accept(true);
        })).getDiff(this.workspaceProject.getSpace().getName(), this.workspaceProject.getRepository().getAlias(), Long.valueOf(changeRequest.getId()));
    }

    private void setupFilesSummary(List<ChangeRequestDiff> diffList) {
        int changedFilesCount = diffList.size();
        int addedLinesCount = diffList.stream().mapToInt(ChangeRequestDiff::getAddedLinesCount).sum();
        int deletedLinesCount = diffList.stream().mapToInt(ChangeRequestDiff::getDeletedLinesCount).sum();
        this.view.setFilesSummary(this.changeRequestUtils.formatFilesSummary(changedFilesCount, addedLinesCount, deletedLinesCount));
    }

    private void setupDiffList(List<ChangeRequestDiff> diffList, boolean warnConflict) {
        this.view.clearDiffList();
        diffList.forEach(diff -> {
            DiffItemPresenter item = (DiffItemPresenter)this.diffItemPresenterInstances.get();
            item.setup((ChangeRequestDiff)diff, warnConflict);
            this.view.addDiffItem(item.getView(), item::draw);
        });
    }

    private void destroyDiffItems() {
        this.diffItemPresenterInstances.destroyAll();
    }

    public static interface View
    extends UberElemental<ChangedFilesScreenPresenter> {
        public void addDiffItem(DiffItemPresenter.View var1, Runnable var2);

        public void clearDiffList();

        public void setFilesSummary(String var1);

        public void resetAll();

        public void showDiffList(boolean var1);
    }
}

