/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.widgets.example;

import elemental2.dom.HTMLElement;
import java.util.List;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.library.client.widgets.example.ExampleProjectWidgetContainer;
import org.kie.workbench.common.screens.library.client.widgets.example.branchselector.BranchSelectorPopUpPresenter;
import org.kie.workbench.common.screens.library.client.widgets.example.errors.ExampleProjectErrorPresenter;
import org.kie.workbench.common.screens.library.client.widgets.example.errors.ExampleProjectOkPresenter;
import org.uberfire.client.mvp.UberElemental;

public class ExampleProjectWidget {
    private ExampleProjectWidgetContainer container;
    private ImportProject model;
    private boolean selected;
    private final View view;
    private final ExampleProjectOkPresenter exampleProjectOkPresenter;
    private final ExampleProjectErrorPresenter exampleProjectErrorPresenter;
    private final BranchSelectorPopUpPresenter branchSelectorPopUpPresenter;

    @Inject
    public ExampleProjectWidget(View view, ExampleProjectOkPresenter exampleProjectOkPresenter, ExampleProjectErrorPresenter exampleProjectErrorPresenter, BranchSelectorPopUpPresenter branchSelectorPopUpPresenter) {
        this.view = view;
        this.exampleProjectOkPresenter = exampleProjectOkPresenter;
        this.exampleProjectErrorPresenter = exampleProjectErrorPresenter;
        this.branchSelectorPopUpPresenter = branchSelectorPopUpPresenter;
    }

    public void init(ImportProject importProject, ExampleProjectWidgetContainer container) {
        this.view.init(this);
        this.container = container;
        this.model = importProject;
        this.view.setup(importProject.getName(), importProject.getDescription(), this.buildErrors(importProject), importProject.canSelectBranches());
        this.disableViewIfHasErrors();
    }

    private void disableViewIfHasErrors() {
        if (this.hasErrors()) {
            this.view.setDisabled();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getName() {
        return this.model.getName();
    }

    public void click() {
        if (!this.isSelected()) {
            this.container.selectProject(this);
        } else {
            this.unselect();
        }
    }

    public void select() {
        if (!this.hasErrors()) {
            this.setSelected(true);
            this.getView().setActive();
        }
    }

    public void unselect() {
        this.setSelected(false);
        this.getView().unsetActive();
    }

    public void selectBranches() {
        this.branchSelectorPopUpPresenter.setup(this.model, this.view::changeBranchSelectorTitle);
    }

    private HTMLElement buildErrors(ImportProject importProject) {
        List errors = importProject.getErrors();
        if (errors.isEmpty()) {
            return this.exampleProjectOkPresenter.getView().getElement();
        }
        this.exampleProjectErrorPresenter.initialize(errors);
        return this.exampleProjectErrorPresenter.getView().getElement();
    }

    private boolean hasErrors() {
        return !this.model.getErrors().isEmpty();
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberElemental<ExampleProjectWidget>,
    IsElement {
        public void setup(String var1, String var2, HTMLElement var3);

        public void setup(String var1, String var2, HTMLElement var3, boolean var4);

        public void setActive();

        public void unsetActive();

        public void setDisabled();

        public void changeBranchSelectorTitle(List<String> var1);
    }
}

