/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.delete;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

public class DeleteProjectPopUpScreen {
    private WorkspaceProject project;
    private View view;
    private LibraryPlaces libraryPlaces;

    @Inject
    public DeleteProjectPopUpScreen(View view, LibraryPlaces libraryPlaces) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public void show(WorkspaceProject project) {
        this.project = project;
        this.view.show(project.getName());
    }

    public void delete() {
        String confirmedName = this.view.getConfirmedName();
        if (!this.project.getName().equals(confirmedName)) {
            this.view.showError(this.view.getWrongConfirmedNameValidationMessage());
            return;
        }
        this.libraryPlaces.closeAllPlacesOrNothing(() -> {
            this.view.showBusyIndicator(this.view.getDeletingMessage());
            this.libraryPlaces.deleteProject(this.project, this.view);
        });
    }

    public void cancel() {
        this.view.hide();
    }

    public static interface View
    extends UberElemental<DeleteProjectPopUpScreen>,
    HasBusyIndicator {
        public String getConfirmedName();

        public void show(String var1);

        public void showError(String var1);

        public void hide();

        public String getWrongConfirmedNameValidationMessage();

        public String getDeletingMessage();
    }
}

