/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.sections.knowledgebases.item;

import elemental2.dom.Element;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.screens.library.client.settings.sections.knowledgebases.KnowledgeBasesPresenter;
import org.kie.workbench.common.screens.library.client.settings.sections.knowledgebases.item.DefaultKnowledgeBaseChange;
import org.kie.workbench.common.screens.library.client.settings.sections.knowledgebases.item.includedknowledgebases.IncludedKnowledgeBaseItemPresenter;
import org.kie.workbench.common.screens.library.client.settings.sections.knowledgebases.item.knowledgesessions.KnowledgeSessionsModal;
import org.kie.workbench.common.screens.library.client.settings.sections.knowledgebases.item.packages.PackageItemPresenter;
import org.kie.workbench.common.services.shared.kmodule.KBaseModel;
import org.kie.workbench.common.services.shared.kmodule.SingleValueItemObjectModel;
import org.kie.workbench.common.widgets.client.widget.ListItemPresenter;
import org.kie.workbench.common.widgets.client.widget.ListItemView;
import org.kie.workbench.common.widgets.client.widget.ListPresenter;

@Dependent
public class KnowledgeBaseItemPresenter
extends ListItemPresenter<KBaseModel, KnowledgeBasesPresenter, View> {
    private final Event<DefaultKnowledgeBaseChange> defaultKnowledgeBaseChangeEvent;
    private final KnowledgeSessionsModal knowledgeSessionsModal;
    private final IncludedKnowledgeBasesListPresenter includedKnowledgeBasesListPresenter;
    private final PackageListPresenter packageListPresenter;
    KBaseModel kBaseModel;
    KnowledgeBasesPresenter parentPresenter;

    @Inject
    public KnowledgeBaseItemPresenter(View view, Event<DefaultKnowledgeBaseChange> defaultKnowledgeBaseChangeEvent, KnowledgeSessionsModal knowledgeSessionsModal, IncludedKnowledgeBasesListPresenter includedKnowledgeBasesListPresenter, PackageListPresenter packageListPresenter) {
        super((ListItemView)view);
        this.defaultKnowledgeBaseChangeEvent = defaultKnowledgeBaseChangeEvent;
        this.knowledgeSessionsModal = knowledgeSessionsModal;
        this.includedKnowledgeBasesListPresenter = includedKnowledgeBasesListPresenter;
        this.packageListPresenter = packageListPresenter;
    }

    public KnowledgeBaseItemPresenter setup(KBaseModel kBaseModel, KnowledgeBasesPresenter parentPresenter) {
        this.kBaseModel = kBaseModel;
        this.parentPresenter = parentPresenter;
        ((View)this.view).init((Object)this);
        ((View)this.view).setName(kBaseModel.getName());
        ((View)this.view).setDefault(kBaseModel.isDefault());
        ((View)this.view).setKnowledgeSessionsCount(kBaseModel.getKSessions().size());
        this.knowledgeSessionsModal.setup(this);
        ((View)this.view).setupEqualBehaviorSelect(kBaseModel);
        ((View)this.view).setupEventProcessingModelSelect(kBaseModel);
        this.includedKnowledgeBasesListPresenter.setup(((View)this.view).getIncludedKnowledgeBasesListElement(), kBaseModel.getIncludes(), (knowledgeBaseName, presenter) -> presenter.setup((SingleValueItemObjectModel)knowledgeBaseName, this));
        this.packageListPresenter.setup(((View)this.view).getPackagesListElement(), kBaseModel.getPackages(), (packageName, presenter) -> presenter.setup((SingleValueItemObjectModel)packageName, this));
        return this;
    }

    public void remove() {
        super.remove();
        this.fireChangeEvent();
    }

    public void onNameChange(String name) {
        this.kBaseModel.setName(name);
        this.fireChangeEvent();
    }

    public void fireChangeEvent() {
        this.parentPresenter.fireChangeEvent();
    }

    public KBaseModel getObject() {
        return this.kBaseModel;
    }

    public void addNewIncludedKnowledgeBase() {
        this.includedKnowledgeBasesListPresenter.add(new SingleValueItemObjectModel(""));
        this.parentPresenter.fireChangeEvent();
    }

    public void addPackage() {
        this.packageListPresenter.add(new SingleValueItemObjectModel(""));
        this.parentPresenter.fireChangeEvent();
    }

    public void showKnowledgeSessionsModal() {
        this.knowledgeSessionsModal.show();
    }

    public void signalAddedOrRemoved() {
        ((View)this.view).setKnowledgeSessionsCount(this.kBaseModel.getKSessions().size());
        this.parentPresenter.fireChangeEvent();
    }

    public void setDefault(boolean isDefault) {
        this.kBaseModel.setDefault(isDefault);
        this.defaultKnowledgeBaseChangeEvent.fire((Object)new DefaultKnowledgeBaseChange(this.kBaseModel));
        this.parentPresenter.fireChangeEvent();
    }

    public void onDefaultKnowledgeSessionChanged(@Observes DefaultKnowledgeBaseChange event) {
        if (!event.getNewDefault().equals((Object)this.kBaseModel)) {
            this.kBaseModel.setDefault(false);
        }
    }

    @Dependent
    public static class PackageListPresenter
    extends ListPresenter<SingleValueItemObjectModel, PackageItemPresenter> {
        @Inject
        public PackageListPresenter(ManagedInstance<PackageItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    @Dependent
    public static class IncludedKnowledgeBasesListPresenter
    extends ListPresenter<SingleValueItemObjectModel, IncludedKnowledgeBaseItemPresenter> {
        @Inject
        public IncludedKnowledgeBasesListPresenter(ManagedInstance<IncludedKnowledgeBaseItemPresenter> itemPresenters) {
            super(itemPresenters);
        }
    }

    public static interface View
    extends ListItemView<KnowledgeBaseItemPresenter>,
    IsElement {
        public void setName(String var1);

        public Element getPackagesListElement();

        public Element getIncludedKnowledgeBasesListElement();

        public void setDefault(boolean var1);

        public void setupEqualBehaviorSelect(KBaseModel var1);

        public void setupEventProcessingModelSelect(KBaseModel var1);

        public void setKnowledgeSessionsCount(int var1);
    }
}

