/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.util.breadcrumb;

import elemental2.promise.Promise;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryUpdatedEvent;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.services.datamodel.util.SortHelper;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.widgets.common.client.breadcrumbs.widget.BreadcrumbPresenter;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ProjectBranchBreadcrumb
implements BreadcrumbPresenter {
    private final View view;
    private List<Branch> branches;
    private LibraryPlaces libraryPlaces;
    private Event<NotificationEvent> notificationEvent;
    private ProjectController projectController;
    private Promises promises;
    public static final Comparator<Branch> BRANCH_ALPHABETICAL_ORDER_COMPARATOR = (branch1, branch2) -> SortHelper.ALPHABETICAL_ORDER_COMPARATOR.compare(branch1.getName(), branch2.getName());

    @Inject
    public ProjectBranchBreadcrumb(View view, LibraryPlaces libraryPlaces, Event<NotificationEvent> notificationEvent, ProjectController projectController, Promises promises) {
        this.view = view;
        this.libraryPlaces = libraryPlaces;
        this.notificationEvent = notificationEvent;
        this.projectController = projectController;
        this.promises = promises;
    }

    public ProjectBranchBreadcrumb setup(Collection<Branch> branches) {
        HashSet branchesSet = new HashSet();
        List<Promise> canReadBranchPromises = branches.stream().map(b -> this.projectController.canReadBranch(this.libraryPlaces.getActiveWorkspace(), b.getName()).then(canReadBranch -> {
            if (canReadBranch.booleanValue()) {
                branchesSet.add(b);
            }
            return this.promises.resolve((Object)true);
        })).collect(Collectors.toList());
        this.promises.all(canReadBranchPromises.toArray(new Promise[canReadBranchPromises.size()])).then(ignored -> {
            this.branches = branchesSet.stream().sorted(BRANCH_ALPHABETICAL_ORDER_COMPARATOR).collect(Collectors.toList());
            this.view.init(this);
            return this.promises.resolve();
        });
        return this;
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public Branch getCurrentBranch() {
        return this.libraryPlaces.getActiveWorkspace().getBranch();
    }

    public List<Branch> getBranches() {
        return this.branches;
    }

    public UberElemental<? extends BreadcrumbPresenter> getView() {
        return this.view;
    }

    public void onBranchChanged(Branch branch) {
        this.libraryPlaces.goToProject(this.libraryPlaces.getActiveWorkspace(), branch);
    }

    public void newBranchEvent(@Observes NewBranchEvent newBranchEvent) {
        Repository repository;
        String userIdentifier = newBranchEvent.getUserIdentifier();
        if (this.libraryPlaces.isThisUserAccessingThisRepository(userIdentifier, repository = newBranchEvent.getRepository())) {
            this.libraryPlaces.goToProject(this.libraryPlaces.getActiveWorkspace(), (Branch)repository.getBranch(newBranchEvent.getNewBranchName()).get());
        }
    }

    public void repositoryUpdatedEvent(@Observes RepositoryUpdatedEvent event) {
        Repository repository = event.getRepository();
        if (this.libraryPlaces.isThisRepositoryBeingAccessed(repository)) {
            this.updateBranches(repository.getBranches());
        }
    }

    private void updateBranches(Collection<Branch> branches) {
        if (!branches.contains(this.getCurrentBranch())) {
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getBranchDeletedMessage(this.getCurrentBranch().getName()), NotificationEvent.NotificationType.DEFAULT));
            Optional defaultBranch = this.libraryPlaces.getActiveWorkspace().getRepository().getDefaultBranch();
            if (defaultBranch.isPresent()) {
                this.libraryPlaces.goToProject(this.libraryPlaces.getActiveWorkspace(), (Branch)defaultBranch.get());
            } else {
                this.libraryPlaces.goToLibrary();
            }
        } else {
            this.setup(branches);
        }
    }

    public static interface View
    extends UberElemental<ProjectBranchBreadcrumb> {
        public String getBranchDeletedMessage(String var1);
    }
}

