/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab;

import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.events.RepositoryContributorsUpdatedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsListService;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.ContributorsSecurityUtils;
import org.kie.workbench.common.screens.library.client.screens.organizationalunit.contributors.tab.SpaceContributorsListServiceImpl;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.promise.Promises;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Contributor;
import org.uberfire.security.ContributorType;

public class ProjectContributorsListServiceImpl
implements ContributorsListService {
    private LibraryPlaces libraryPlaces;
    private Caller<RepositoryService> repositoryService;
    private SpaceContributorsListServiceImpl spaceContributorsListService;
    private SessionInfo sessionInfo;
    private ProjectController projectController;
    private ContributorsSecurityUtils contributorsSecurityUtils;
    private Promises promises;
    private Consumer<Collection<Contributor>> contributorsConsumerForExternalChange;

    @Inject
    public ProjectContributorsListServiceImpl(LibraryPlaces libraryPlaces, Caller<RepositoryService> repositoryService, SpaceContributorsListServiceImpl spaceContributorsListService, SessionInfo sessionInfo, ProjectController projectController, ContributorsSecurityUtils contributorsSecurityUtils, Promises promises) {
        this.libraryPlaces = libraryPlaces;
        this.repositoryService = repositoryService;
        this.spaceContributorsListService = spaceContributorsListService;
        this.sessionInfo = sessionInfo;
        this.projectController = projectController;
        this.contributorsSecurityUtils = contributorsSecurityUtils;
        this.promises = promises;
        this.contributorsConsumerForExternalChange = null;
    }

    @Override
    public void getContributors(Consumer<List<Contributor>> contributorsConsumer) {
        ((RepositoryService)this.repositoryService.call(repository -> contributorsConsumer.accept(new ArrayList(repository.getContributors())))).getRepositoryFromSpace(this.libraryPlaces.getActiveSpace().getSpace(), this.libraryPlaces.getActiveWorkspace().getRepository().getAlias());
    }

    @Override
    public void saveContributors(List<Contributor> contributors, Runnable successCallback, ErrorCallback<Message> errorCallback) {
        ((RepositoryService)this.repositoryService.call(repository -> ((RepositoryService)this.repositoryService.call(Void2 -> successCallback.run(), errorCallback)).updateContributors(repository, contributors))).getRepositoryFromSpace(this.libraryPlaces.getActiveSpace().getSpace(), this.libraryPlaces.getActiveWorkspace().getRepository().getAlias());
    }

    @Override
    public Promise<Boolean> canEditContributors(List<Contributor> contributors, ContributorType type) {
        return this.projectController.canUpdateProject(this.libraryPlaces.getActiveWorkspace()).then(canUpdateProject -> {
            if (canUpdateProject.booleanValue()) {
                return this.promises.resolve((Object)true);
            }
            Optional<Contributor> contributor = contributors.stream().filter(c -> c.getUsername().equals(this.sessionInfo.getIdentity().getIdentifier())).findFirst();
            if (contributor.isPresent()) {
                ContributorType userContributorType = contributor.get().getType();
                return this.promises.resolve((Object)this.contributorsSecurityUtils.canUserEditContributorOfType(userContributorType, type));
            }
            return this.promises.resolve((Object)false);
        });
    }

    @Override
    public void getValidUsernames(Consumer<List<String>> validUsernamesConsumer) {
        this.spaceContributorsListService.getContributors(contributors -> validUsernamesConsumer.accept(contributors.stream().map(c -> c.getUsername()).collect(Collectors.toList())));
    }

    @Override
    public void onExternalChange(Consumer<Collection<Contributor>> contributorsConsumer) {
        this.contributorsConsumerForExternalChange = contributorsConsumer;
    }

    @Override
    public boolean requireValidUsername() {
        return true;
    }

    @Override
    public String getInvalidNameMessageConstant() {
        return "ProjectInvalidContributorName";
    }

    public void onRepositoryContributorsUpdatedEvent(@Observes RepositoryContributorsUpdatedEvent repositoryContributorsUpdatedEvent) {
        if (this.contributorsConsumerForExternalChange != null && repositoryContributorsUpdatedEvent.getRepository().getIdentifier().equals(this.libraryPlaces.getActiveWorkspace().getRepository().getIdentifier())) {
            this.contributorsConsumerForExternalChange.accept(repositoryContributorsUpdatedEvent.getRepository().getContributors());
        }
    }
}

