/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.review.tab.overview;

import java.util.Comparator;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequest;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestComment;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatus;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.ChangeRequestUtils;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.review.comment.CommentItemPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.rpc.SessionInfo;

@Dependent
public class OverviewScreenPresenter {
    private static final int COMMENTS_PAGE_SIZE = 10;
    private final View view;
    private final TranslationService ts;
    private final ManagedInstance<CommentItemPresenter> commentItemPresenterInstances;
    private final Caller<ChangeRequestService> changeRequestService;
    private final LibraryPlaces libraryPlaces;
    private final ChangeRequestUtils changeRequestUtils;
    private final SessionInfo sessionInfo;
    private WorkspaceProject workspaceProject;
    private long currentChangeRequestId;
    private String changeRequestAuthorId;
    private int commentCurrentPage;
    private int commentTotalPages;

    @Inject
    public OverviewScreenPresenter(View view, TranslationService ts, ManagedInstance<CommentItemPresenter> commentItemPresenterInstances, Caller<ChangeRequestService> changeRequestService, LibraryPlaces libraryPlaces, ChangeRequestUtils changeRequestUtils, SessionInfo sessionInfo) {
        this.view = view;
        this.ts = ts;
        this.commentItemPresenterInstances = commentItemPresenterInstances;
        this.changeRequestService = changeRequestService;
        this.libraryPlaces = libraryPlaces;
        this.changeRequestUtils = changeRequestUtils;
        this.sessionInfo = sessionInfo;
    }

    @PostConstruct
    public void postConstruct() {
        this.workspaceProject = this.libraryPlaces.getActiveWorkspace();
        this.view.init(this);
        this.view.setRevertFailedTooltipText(this.ts.getTranslation("RevertFailedTooltip"));
    }

    public View getView() {
        return this.view;
    }

    public void addComment() {
        String commentText = this.view.getCommentText();
        if (this.isInvalidContent(commentText)) {
            this.view.setCommentInputError(this.ts.getTranslation("MissingCommentText"));
        } else {
            ((ChangeRequestService)this.changeRequestService.call(v -> {
                this.view.clearCommentInputError();
                this.view.clearCommentInputField();
            })).addComment(this.workspaceProject.getSpace().getName(), this.workspaceProject.getRepository().getAlias(), Long.valueOf(this.currentChangeRequestId), commentText);
        }
    }

    public void reset() {
        this.view.resetAll();
        this.commentCurrentPage = 1;
    }

    public void setup(ChangeRequest changeRequest, Consumer<Boolean> finishLoadingCallback) {
        this.currentChangeRequestId = changeRequest.getId();
        this.changeRequestAuthorId = changeRequest.getAuthorId();
        this.view.setStatus(this.changeRequestUtils.formatStatus(changeRequest.getStatus()));
        this.view.setAuthor(changeRequest.getAuthorId());
        this.view.setCreatedDate(this.changeRequestUtils.formatCreatedDate(changeRequest.getCreatedDate()));
        this.view.setSummary(changeRequest.getSummary());
        this.view.setDescription(changeRequest.getDescription());
        this.view.setSourceBranch(changeRequest.getSourceBranch());
        this.view.setTargetBranch(changeRequest.getTargetBranch());
        this.view.setCommentInputPlaceHolder(this.ts.getTranslation("LeaveAComment"));
        this.view.enableSummaryEditMode(false);
        this.view.enableDescriptionEditMode(false);
        this.view.showEditModes(this.isUserAuthor());
        this.view.showRevertFailedTooltip(changeRequest.getStatus() == ChangeRequestStatus.REVERT_FAILED);
        this.refreshCommentList(finishLoadingCallback);
    }

    public void checkWarnConflict(ChangeRequest changeRequest) {
        this.view.showConflictWarning(changeRequest.isConflict() != false && changeRequest.getStatus() == ChangeRequestStatus.OPEN);
    }

    public void startEditSummary() {
        this.view.enableSummaryEditMode(true);
    }

    public void saveSummaryEdition() {
        String summaryInputText;
        if (this.isUserAuthor() && !this.isInvalidContent(summaryInputText = this.view.getSummaryInputText())) {
            ((ChangeRequestService)this.changeRequestService.call(v -> {
                this.view.setSummary(summaryInputText);
                this.view.enableSummaryEditMode(false);
            })).updateChangeRequestSummary(this.workspaceProject.getSpace().getName(), this.workspaceProject.getRepository().getAlias(), Long.valueOf(this.currentChangeRequestId), summaryInputText);
        }
    }

    public void cancelSummaryEdition() {
        this.view.enableSummaryEditMode(false);
    }

    public void startEditDescription() {
        this.view.enableDescriptionEditMode(true);
    }

    public void saveDescriptionEdition() {
        String descriptionInputText;
        if (this.isUserAuthor() && !this.isInvalidContent(descriptionInputText = this.view.getDescriptionInputText())) {
            ((ChangeRequestService)this.changeRequestService.call(v -> {
                this.view.setDescription(descriptionInputText);
                this.view.enableDescriptionEditMode(false);
            })).updateChangeRequestDescription(this.workspaceProject.getSpace().getName(), this.workspaceProject.getRepository().getAlias(), Long.valueOf(this.currentChangeRequestId), descriptionInputText);
        }
    }

    public void cancelDescriptionEdition() {
        this.view.enableDescriptionEditMode(false);
    }

    public void nextCommentPage() {
        if (this.commentCurrentPage + 1 <= this.commentTotalPages) {
            ++this.commentCurrentPage;
            this.refreshCommentList(b -> {});
        }
    }

    public void prevCommentPage() {
        if (this.commentCurrentPage - 1 >= 1) {
            --this.commentCurrentPage;
            this.refreshCommentList(b -> {});
        }
    }

    public void setCommentCurrentPage(int currentCommentPage) {
        if (currentCommentPage <= this.commentTotalPages && currentCommentPage > 0) {
            this.commentCurrentPage = currentCommentPage;
            this.refreshCommentList(b -> {});
        } else {
            this.view.setCommentCurrentPage(this.commentCurrentPage);
        }
    }

    private void refreshCommentList(Consumer<Boolean> finishLoadingCallback) {
        ((ChangeRequestService)this.changeRequestService.call(paginatedList -> {
            this.setupCommentToolbar(paginatedList.getTotal(), paginatedList.getChangeRequestComments().size());
            this.view.clearCommentList();
            paginatedList.getChangeRequestComments().stream().sorted(Comparator.comparing(ChangeRequestComment::getCreatedDate)).forEach(comment -> {
                CommentItemPresenter item = (CommentItemPresenter)this.commentItemPresenterInstances.get();
                item.setup(this.currentChangeRequestId, comment.getId(), comment.getAuthorId(), comment.getCreatedDate(), comment.getText());
                this.view.addCommentItem(item.getView());
            });
            finishLoadingCallback.accept(true);
        })).getComments(this.workspaceProject.getSpace().getName(), this.workspaceProject.getRepository().getAlias(), Long.valueOf(this.currentChangeRequestId), Integer.valueOf(Math.max(0, this.commentCurrentPage - 1)), Integer.valueOf(10));
    }

    private void setupCommentToolbar(int total, int paginatedCount) {
        this.setupCommentCounters(total);
        boolean isEmpty = paginatedCount == 0;
        this.view.setCommentsHeader(isEmpty ? this.ts.getTranslation("NoComments") : this.ts.getTranslation("Comments"));
        this.view.showCommentsToolbar(!isEmpty);
    }

    private boolean isInvalidContent(String content) {
        return content == null || content.trim().isEmpty();
    }

    private boolean isUserAuthor() {
        return this.changeRequestAuthorId.equals(this.sessionInfo.getIdentity().getIdentifier());
    }

    private void setupCommentCounters(int count) {
        int offset = (this.commentCurrentPage - 1) * 10;
        int fromCount = count > 0 ? offset + 1 : offset;
        int toCount = this.resolveCommentCounter(count, offset + 10);
        int totalCount = this.resolveCommentCounter(count, 0);
        String indicatorText = this.ts.format("ItemCountIndicatorText", new Object[]{fromCount, toCount, totalCount});
        this.view.setCommentPageIndicator(indicatorText);
        this.commentTotalPages = (int)Math.ceil((float)count / 10.0f);
        String totalText = this.ts.format("OfN", new Object[]{Math.max(this.commentTotalPages, 1)});
        this.view.setCommentTotalPages(totalText);
        this.view.setCommentCurrentPage(this.commentCurrentPage);
        this.checkCommentPaginationButtons();
    }

    private void checkCommentPaginationButtons() {
        boolean isPreviousButtonEnabled = this.commentCurrentPage > 1;
        boolean isNextButtonEnabled = this.commentCurrentPage < this.commentTotalPages;
        this.view.enableCommentPreviousButton(isPreviousButtonEnabled);
        this.view.enableCommentNextButton(isNextButtonEnabled);
    }

    private int resolveCommentCounter(int numberOfComments, int otherCounter) {
        if (numberOfComments < otherCounter || otherCounter == 0) {
            return numberOfComments;
        }
        return otherCounter;
    }

    public static interface View
    extends UberElemental<OverviewScreenPresenter> {
        public void setStatus(String var1);

        public void setAuthor(String var1);

        public void setCreatedDate(String var1);

        public void setSummary(String var1);

        public String getSummaryInputText();

        public void setDescription(String var1);

        public String getDescriptionInputText();

        public void setSourceBranch(String var1);

        public void setTargetBranch(String var1);

        public void setCommentInputPlaceHolder(String var1);

        public void addCommentItem(CommentItemPresenter.View var1);

        public void clearCommentList();

        public void setCommentInputError(String var1);

        public void clearCommentInputError();

        public String getCommentText();

        public void clearCommentInputField();

        public void enableSummaryEditMode(boolean var1);

        public void enableDescriptionEditMode(boolean var1);

        public void showEditModes(boolean var1);

        public void showConflictWarning(boolean var1);

        public void resetAll();

        public void setCommentsHeader(String var1);

        public void setCommentCurrentPage(int var1);

        public void setCommentPageIndicator(String var1);

        public void setCommentTotalPages(String var1);

        public void enableCommentPreviousButton(boolean var1);

        public void enableCommentNextButton(boolean var1);

        public void showCommentsToolbar(boolean var1);

        public void setRevertFailedTooltipText(String var1);

        public void showRevertFailedTooltip(boolean var1);
    }
}

