/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.screens.project.changerequest.submit;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestAlreadyOpenException;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestDiff;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.library.api.RepositoryFileListUpdatedEvent;
import org.kie.workbench.common.screens.library.client.perspective.LibraryPerspective;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.ChangeRequestUtils;
import org.kie.workbench.common.screens.library.client.screens.project.changerequest.diff.DiffItemPresenter;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.services.datamodel.util.SortHelper;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@WorkbenchScreen(identifier="SubmitChangeRequestScreen", owningPerspective=LibraryPerspective.class)
public class SubmitChangeRequestScreenPresenter {
    private final View view;
    private final TranslationService ts;
    private final LibraryPlaces libraryPlaces;
    private final ManagedInstance<DiffItemPresenter> diffItemPresenterInstances;
    private final Caller<ChangeRequestService> changeRequestService;
    private final ProjectController projectController;
    private final Promises promises;
    private final BusyIndicatorView busyIndicatorView;
    private final ChangeRequestUtils changeRequestUtils;
    private final Event<NotificationEvent> notificationEvent;
    private WorkspaceProject workspaceProject;
    private String currentBranchName;
    private String selectedBranch;

    @Inject
    public SubmitChangeRequestScreenPresenter(View view, TranslationService ts, LibraryPlaces libraryPlaces, ManagedInstance<DiffItemPresenter> diffItemPresenterInstances, Caller<ChangeRequestService> changeRequestService, ProjectController projectController, Promises promises, BusyIndicatorView busyIndicatorView, ChangeRequestUtils changeRequestUtils, Event<NotificationEvent> notificationEvent) {
        this.view = view;
        this.ts = ts;
        this.libraryPlaces = libraryPlaces;
        this.diffItemPresenterInstances = diffItemPresenterInstances;
        this.changeRequestService = changeRequestService;
        this.projectController = projectController;
        this.promises = promises;
        this.busyIndicatorView = busyIndicatorView;
        this.changeRequestUtils = changeRequestUtils;
        this.notificationEvent = notificationEvent;
    }

    @PostConstruct
    public void postConstruct() {
        this.workspaceProject = this.libraryPlaces.getActiveWorkspace();
        this.view.init(this);
        this.view.setTitle(this.getTitle());
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.ts.getTranslation("SubmitChangeRequest");
    }

    @WorkbenchPartView
    public View getView() {
        return this.view;
    }

    @OnClose
    public void onClose() {
        this.destroyDiffItems();
    }

    public void refreshOnFocus(@Observes SelectPlaceEvent selectPlaceEvent) {
        PlaceRequest place;
        if (this.workspaceProject != null && this.workspaceProject.getMainModule() != null && (place = selectPlaceEvent.getPlace()).getIdentifier().equals("SubmitChangeRequestScreen")) {
            this.init();
        }
    }

    public void onRepositoryFileListUpdated(@Observes RepositoryFileListUpdatedEvent event) {
        String updatedBranchName;
        if (event.getRepositoryId().equals(this.workspaceProject.getRepository().getIdentifier()) && (this.currentBranchName.equals(updatedBranchName = event.getBranchName()) || this.selectedBranch.equals(updatedBranchName))) {
            this.updateDiffContainer();
        }
    }

    public void cancel() {
        this.destroyDiffItems();
        this.libraryPlaces.goToProject(this.workspaceProject);
    }

    public void submit() {
        if (!this.validateFields()) {
            return;
        }
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("Loading"));
        this.projectController.canSubmitChangeRequest(this.workspaceProject, this.selectedBranch).then(userCanSubmitChangeRequest -> {
            if (Boolean.TRUE.equals(userCanSubmitChangeRequest)) {
                ((ChangeRequestService)this.changeRequestService.call(item -> {
                    this.busyIndicatorView.hideBusyIndicator();
                    this.notificationEvent.fire((Object)new NotificationEvent(this.ts.format("ChangeRequestSubmitMessage", new Object[]{item.getId()}), NotificationEvent.NotificationType.SUCCESS));
                    this.destroyDiffItems();
                    this.libraryPlaces.goToChangeRequestReviewScreen(item.getId());
                }, this.createChangeRequestErrorCallback())).createChangeRequest(this.workspaceProject.getSpace().getName(), this.workspaceProject.getRepository().getAlias(), this.currentBranchName, this.selectedBranch, this.view.getSummary(), this.view.getDescription());
            }
            return this.promises.resolve();
        });
    }

    public void selectBranch(String branchName) {
        this.selectedBranch = branchName;
        this.updateDiffContainer();
    }

    public void updateDiffContainer() {
        this.busyIndicatorView.showBusyIndicator(this.ts.getTranslation("Loading"));
        ((ChangeRequestService)this.changeRequestService.call(diffList -> {
            boolean hideDiff = diffList.isEmpty();
            if (hideDiff) {
                this.setupEmptyDiffList();
            } else {
                this.setupPopulatedDiffList((List<ChangeRequestDiff>)diffList);
            }
            this.view.showDiff(!hideDiff);
            this.busyIndicatorView.hideBusyIndicator();
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).getDiff(this.workspaceProject.getSpace().getName(), this.workspaceProject.getRepository().getAlias(), this.currentBranchName, this.selectedBranch);
    }

    private ErrorCallback<Object> createChangeRequestErrorCallback() {
        return (message, throwable) -> {
            this.busyIndicatorView.hideBusyIndicator();
            if (throwable instanceof ChangeRequestAlreadyOpenException) {
                Long changeRequestId = ((ChangeRequestAlreadyOpenException)throwable).getChangeRequestId();
                this.notificationEvent.fire((Object)new NotificationEvent(this.ts.format("ChangeRequestAlreadyOpenMessage", new Object[]{changeRequestId, this.currentBranchName, this.selectedBranch}), NotificationEvent.NotificationType.WARNING));
                return false;
            }
            return true;
        };
    }

    private void destroyDiffItems() {
        this.diffItemPresenterInstances.destroyAll();
    }

    private void init() {
        this.currentBranchName = this.workspaceProject.getBranch().getName();
        Branch defaultBranch = (Branch)this.workspaceProject.getRepository().getDefaultBranch().orElseThrow(() -> new IllegalStateException("The default branch does not exist"));
        this.selectedBranch = defaultBranch.getName();
        this.reset();
        this.setup();
    }

    private void reset() {
        this.view.resetAll();
    }

    private void setup() {
        this.updateDestinationBranchList();
        this.updateDiffContainer();
    }

    private void setupEmptyDiffList() {
        this.destroyDiffItems();
        this.view.showWarning(false);
        this.view.clearDiffList();
        this.view.enableSubmitButton(false);
        this.view.setFilesSummary(this.ts.getTranslation("BranchesAreEven"));
    }

    private boolean validateFields() {
        boolean isValid = true;
        Predicate<String> isInvalidContent = content -> content == null || content.trim().isEmpty();
        this.view.clearErrors();
        if (isInvalidContent.test(this.view.getSummary())) {
            this.view.setSummaryError();
            isValid = false;
        }
        if (isInvalidContent.test(this.view.getDescription())) {
            this.view.setDescriptionError();
            isValid = false;
        }
        return isValid;
    }

    private void setupPopulatedDiffList(List<ChangeRequestDiff> diffList) {
        int changedFilesCount = diffList.size();
        int addedLinesCount = diffList.stream().mapToInt(ChangeRequestDiff::getAddedLinesCount).sum();
        int deletedLinesCount = diffList.stream().mapToInt(ChangeRequestDiff::getDeletedLinesCount).sum();
        this.view.showWarning(diffList.stream().anyMatch(ChangeRequestDiff::isConflict));
        this.view.enableSubmitButton(true);
        this.view.setFilesSummary(this.changeRequestUtils.formatFilesSummary(changedFilesCount, addedLinesCount, deletedLinesCount));
        this.destroyDiffItems();
        this.view.clearDiffList();
        diffList.forEach(diff -> {
            DiffItemPresenter item = (DiffItemPresenter)this.diffItemPresenterInstances.get();
            item.setup((ChangeRequestDiff)diff, true);
            this.view.addDiffItem(item.getView(), item::draw);
        });
    }

    private void updateDestinationBranchList() {
        this.projectController.getReadableBranches(this.libraryPlaces.getActiveWorkspace()).then(branches -> {
            List<String> destinationBranchNames = branches.stream().map(Branch::getName).filter(branchName -> !branchName.equals(this.currentBranchName)).sorted(SortHelper.ALPHABETICAL_ORDER_COMPARATOR).collect(Collectors.toList());
            int selectedBranchIdx = IntStream.range(0, destinationBranchNames.size()).filter(i -> this.selectedBranch.equals(destinationBranchNames.get(i))).findFirst().orElse(0);
            this.view.setDestinationBranches(destinationBranchNames, selectedBranchIdx);
            return this.promises.resolve();
        });
    }

    public static interface View
    extends UberElemental<SubmitChangeRequestScreenPresenter> {
        public void setTitle(String var1);

        public void setDestinationBranches(List<String> var1, int var2);

        public void showWarning(boolean var1);

        public void addDiffItem(DiffItemPresenter.View var1, Runnable var2);

        public String getSummary();

        public String getDescription();

        public void setDescription(String var1);

        public void clearErrors();

        public void clearDiffList();

        public void setFilesSummary(String var1);

        public void enableSubmitButton(boolean var1);

        public void setSummaryError();

        public void setDescriptionError();

        public void showDiff(boolean var1);

        public void clearInputFields();

        public void resetAll();
    }
}

