/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.sections.dependencies;

import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Dependency;
import org.kie.workbench.common.screens.library.client.settings.sections.dependencies.DependenciesPresenter;
import org.kie.workbench.common.screens.projecteditor.client.forms.dependencies.validation.DependencyValidator;
import org.kie.workbench.common.services.shared.allowlist.AllowList;
import org.kie.workbench.common.services.shared.dependencies.EnhancedDependency;
import org.kie.workbench.common.services.shared.dependencies.TransitiveEnhancedDependency;
import org.uberfire.client.mvp.UberElemental;

public class DependenciesItemPresenter {
    private final View view;
    private DependencyValidator validator;
    DependenciesPresenter parentPresenter;
    EnhancedDependency enhancedDependency;

    @Inject
    public DependenciesItemPresenter(View view) {
        this.view = view;
    }

    public DependenciesItemPresenter setup(EnhancedDependency enhancedDependency, AllowList allowList, DependenciesPresenter dependenciesPresenter) {
        this.enhancedDependency = enhancedDependency;
        this.parentPresenter = dependenciesPresenter;
        Dependency dependency = enhancedDependency.getDependency();
        this.validator = new DependencyValidator(dependency);
        this.view.init(this);
        this.view.setGroupId(dependency.getGroupId());
        this.view.setArtifactId(dependency.getArtifactId());
        this.view.setVersion(dependency.getVersion());
        this.view.setPackagesAllowListedState(AllowListedPackagesState.from((Set<String>)allowList, enhancedDependency.getPackages()));
        this.view.setTransitiveDependency(enhancedDependency instanceof TransitiveEnhancedDependency);
        return this;
    }

    public void onGroupIdChange(String groupId) {
        this.enhancedDependency.getDependency().setGroupId(groupId);
        this.validateGroupId();
        this.parentPresenter.fireChangeEvent();
    }

    public void onArtifactIdChange(String artifactId) {
        this.enhancedDependency.getDependency().setArtifactId(artifactId);
        this.validateArtifactId();
        this.parentPresenter.fireChangeEvent();
    }

    public void onVersionChange(String version) {
        this.enhancedDependency.getDependency().setVersion(version);
        this.validateVersion();
        this.parentPresenter.fireChangeEvent();
    }

    public void addAllPackagesToAllowList() {
        this.parentPresenter.addAllToAllowList(this.enhancedDependency.getPackages());
    }

    public void removeAllPackagesFromAllowList() {
        this.parentPresenter.removeAllFromAllowList(this.enhancedDependency.getPackages());
    }

    public void remove() {
        this.parentPresenter.remove(this.enhancedDependency);
    }

    public View getView() {
        return this.view;
    }

    private void validateGroupId() {
        if (this.validator.validateGroupId()) {
            this.view.setGroupIdHelpBock("");
        } else {
            this.view.setGroupIdHelpBock(this.validator.getMessage());
        }
    }

    private void validateArtifactId() {
        if (this.validator.validateArtifactId()) {
            this.view.setArtifactIdHelpBock("");
        } else {
            this.view.setArtifactIdHelpBock(this.validator.getMessage());
        }
    }

    private void validateVersion() {
        if (this.validator.validateVersion()) {
            this.view.setVersionHelpBock("");
        } else {
            this.view.setVersionHelpBock(this.validator.getMessage());
        }
    }

    public static enum AllowListedPackagesState {
        ALL,
        SOME,
        NONE;


        public static AllowListedPackagesState from(Set<String> allowList, Set<String> packages) {
            if (allowList.containsAll(packages)) {
                return ALL;
            }
            if (!Collections.disjoint(allowList, packages)) {
                return SOME;
            }
            return NONE;
        }
    }

    public static interface View
    extends UberElemental<DependenciesItemPresenter> {
        public void setGroupId(String var1);

        public void setArtifactId(String var1);

        public void setVersion(String var1);

        public void setGroupIdHelpBock(String var1);

        public void setArtifactIdHelpBock(String var1);

        public void setVersionHelpBock(String var1);

        public void setPackagesAllowListedState(AllowListedPackagesState var1);

        public void setTransitiveDependency(boolean var1);
    }
}

