/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.sections.dependencies;

import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Dependency;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.sections.dependencies.DependenciesItemPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.sections.MenuItem;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionView;
import org.kie.workbench.common.screens.projecteditor.client.forms.dependencies.DependencySelectorPopup;
import org.kie.workbench.common.screens.projecteditor.client.forms.dependencies.EnhancedDependenciesManager;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.services.shared.dependencies.EnhancedDependencies;
import org.kie.workbench.common.services.shared.dependencies.EnhancedDependency;
import org.uberfire.client.promise.Promises;

public class DependenciesPresenter
extends Section<ProjectScreenModel> {
    private final View view;
    private final DependencySelectorPopup dependencySelectorPopup;
    private final EnhancedDependenciesManager enhancedDependenciesManager;
    private final ManagedInstance<DependenciesItemPresenter> presenters;
    private int currentHashCode = 0;
    ProjectScreenModel model;

    @Inject
    public DependenciesPresenter(View view, Promises promises, MenuItem<ProjectScreenModel> menuItem, DependencySelectorPopup dependencySelectorPopup, Event<SettingsSectionChange<ProjectScreenModel>> settingsSectionChangeEvent, EnhancedDependenciesManager enhancedDependenciesManager, ManagedInstance<DependenciesItemPresenter> presenters) {
        super(settingsSectionChangeEvent, menuItem, promises);
        this.view = view;
        this.dependencySelectorPopup = dependencySelectorPopup;
        this.enhancedDependenciesManager = enhancedDependenciesManager;
        this.presenters = presenters;
    }

    @Override
    public Promise<Void> setup(ProjectScreenModel model) {
        this.model = model;
        this.view.init(this);
        this.dependencySelectorPopup.addSelectionHandler(gav -> {
            Dependency dependency = new Dependency(gav);
            dependency.setScope("compile");
            this.add(dependency);
        });
        return this.promises.create((resolve, reject) -> {
            this.enhancedDependenciesManager.init(model.getPOM(), dependencies -> {
                this.updateHashCode((EnhancedDependencies)dependencies);
                this.view.setItems(this.buildDependencyViews(model, (EnhancedDependencies)dependencies));
                resolve.onInvoke((IThenable)this.promises.resolve());
                this.fireChangeEvent();
            });
            this.enhancedDependenciesManager.update();
        });
    }

    @Override
    public Promise<Object> validate() {
        this.enhancedDependenciesManager.validateDependency();
        return this.promises.resolve();
    }

    private void updateHashCode(EnhancedDependencies enhancedDependencies) {
        this.currentHashCode = enhancedDependencies.asList().hashCode() + this.model.getAllowList().hashCode();
    }

    private List<DependenciesItemPresenter.View> buildDependencyViews(ProjectScreenModel model, EnhancedDependencies dependencies) {
        return dependencies.asList().stream().map(dependency -> ((DependenciesItemPresenter)this.presenters.get()).setup((EnhancedDependency)dependency, model.getAllowList(), this).getView()).collect(Collectors.toList());
    }

    void add(Dependency dependency) {
        this.enhancedDependenciesManager.addNew(dependency);
    }

    public void addNewDependency() {
        this.add(new Dependency());
        this.fireChangeEvent();
    }

    public void addAllToAllowList(Set<String> packages) {
        this.model.getAllowList().addAll(packages);
        this.enhancedDependenciesManager.update();
    }

    public void removeAllFromAllowList(Set<String> packages) {
        this.model.getAllowList().removeAll(packages);
        this.enhancedDependenciesManager.update();
    }

    public void addFromRepository() {
        this.dependencySelectorPopup.show();
    }

    public void remove(EnhancedDependency enhancedDependency) {
        this.enhancedDependenciesManager.delete(enhancedDependency);
    }

    @Override
    public int currentHashCode() {
        return this.currentHashCode;
    }

    @Override
    public SectionView<?> getView() {
        return this.view;
    }

    public static interface View
    extends SectionView<DependenciesPresenter> {
        public void add(DependenciesItemPresenter.View var1);

        public void setItems(List<DependenciesItemPresenter.View> var1);
    }
}

