/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.client.settings.util.dropdown;

import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLUListElement;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.library.client.settings.util.dropdown.KieDropdownElementView;
import org.kie.workbench.common.widgets.client.widget.ListItemPresenter;
import org.kie.workbench.common.widgets.client.widget.ListPresenter;
import org.uberfire.client.mvp.UberElemental;

public class KieDropdownElement<T>
implements IsElement {
    private final View view;
    private final ItemsListPresenter<T> itemsListPresenter;

    @Inject
    public KieDropdownElement(View view, ItemsListPresenter<T> itemsListPresenter) {
        this.view = view;
        this.itemsListPresenter = itemsListPresenter;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void setup(List<Item<T>> items, String initialSelectedLabel) {
        this.itemsListPresenter.setup((Element)this.view.getUl(), items, (item, presenter) -> presenter.setup(item, this));
        this.view.setSelectedLabel(initialSelectedLabel);
    }

    public void setValue(String value) {
        this.view.setSelectedLabel(value);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Dependent
    public static class ItemsListPresenter<T>
    extends ListPresenter<Item<T>, ItemElement<T>> {
        @Inject
        public ItemsListPresenter(ManagedInstance<ItemElement<T>> itemPresenters) {
            super(itemPresenters);
        }
    }

    @Dependent
    public static class ItemElement<T>
    extends ListItemPresenter<Item<T>, KieDropdownElement<T>, KieDropdownElementView.Item<T>> {
        private Item<T> item;
        private KieDropdownElement<T> parentPresenter;

        @Inject
        public ItemElement(KieDropdownElementView.Item<T> view) {
            super(view);
        }

        public ItemElement<T> setup(Item<T> item, KieDropdownElement<T> parentPresenter) {
            this.item = item;
            this.parentPresenter = parentPresenter;
            ((KieDropdownElementView.Item)this.view).init(this);
            ((KieDropdownElementView.Item)this.view).setLabel(item.label);
            ((KieDropdownElementView.Item)this.view).setStatus(item.status);
            return this;
        }

        public Item<T> getObject() {
            return this.item;
        }

        public void onClick() {
            this.item.onClickHandler.accept(this.item.value);
        }
    }

    public static class Item<T> {
        public final T value;
        public final String label;
        public final Status status;
        public final Consumer<T> onClickHandler;
        public final Type type;

        public Item(T value, String label, Status status, Consumer<T> onClickHandler, Type type) {
            this.label = label;
            this.value = value;
            this.status = status;
            this.onClickHandler = onClickHandler;
            this.type = type;
        }

        public static enum Type {
            OPTION,
            ACTION,
            SEPARATOR;

        }

        public static enum Status {
            CHECKED,
            UNCHECKED;

        }
    }

    public static interface View
    extends UberElemental<KieDropdownElement> {
        public HTMLUListElement getUl();

        public void setSelectedLabel(String var1);
    }
}

